/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.ParserFactory;
import net.apartium.cocoabeans.commands.parsers.Scope;
import net.apartium.cocoabeans.commands.parsers.SharedSecrets;
import net.apartium.cocoabeans.commands.parsers.WithParser;
import net.apartium.cocoabeans.commands.parsers.WithParsers;
import net.apartium.cocoabeans.reflect.ConstructorUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class WithParserFactory
implements ParserFactory {
    private static <T extends ArgumentParser<?>> T newInstance(Collection<Constructor<T>> constructors, int priority, String keyword) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> matchingConstructor = null;
        boolean keywordBlank = keyword.isBlank();
        Class<?>[] paramTypes = null;
        for (Constructor<T> constructor : constructors) {
            int paramCount = constructor.getParameterCount();
            if (paramCount != 1 && paramCount != 2) continue;
            paramTypes = constructor.getParameterTypes();
            if (keywordBlank && paramCount == 1 && paramTypes[0].equals(Integer.TYPE)) {
                matchingConstructor = constructor;
                break;
            }
            if (keywordBlank || paramCount != 2) continue;
            if (paramTypes[0].equals(Integer.TYPE) && paramTypes[1].equals(String.class)) {
                matchingConstructor = constructor;
                break;
            }
            if (!paramTypes[0].equals(String.class) || !paramTypes[1].equals(Integer.TYPE)) continue;
            matchingConstructor = constructor;
            break;
        }
        if (matchingConstructor == null) {
            if (keywordBlank) {
                SharedSecrets.LOGGER.log(System.Logger.Level.WARNING, "No constructor found for WithParser with priority {}", priority);
            } else {
                SharedSecrets.LOGGER.log(System.Logger.Level.WARNING, "No constructor found for WithParser with priority {} and keyword {}", priority, keyword);
            }
            return null;
        }
        Object[] params = !keywordBlank ? (paramTypes[0] == Integer.TYPE ? new Object[]{priority, keyword} : new Object[]{keyword, priority}) : new Object[]{priority};
        return (T)((ArgumentParser)matchingConstructor.newInstance(params));
    }

    @NotNull
    public List<ParserFactory.ParserResult> getArgumentParser(GenericNode node, Annotation annotation, GenericDeclaration obj) {
        if (annotation instanceof WithParsers) {
            WithParsers withParsers = (WithParsers)annotation;
            ArrayList<ParserFactory.ParserResult> result = new ArrayList<ParserFactory.ParserResult>(withParsers.value().length);
            for (WithParser withParser : withParsers.value()) {
                result.addAll(this.getArgumentParser(node, withParser, obj));
            }
            return result;
        }
        if (!(annotation instanceof WithParser)) {
            return List.of();
        }
        WithParser withParser = (WithParser)annotation;
        try {
            Object argumentParser = WithParserFactory.newInstance(ConstructorUtils.getDeclaredConstructors(withParser.value()), withParser.priority(), withParser.keyword());
            if (argumentParser == null) {
                return List.of();
            }
            return List.of(new ParserFactory.ParserResult((ArgumentParser<?>)argumentParser, obj instanceof Method ? Scope.VARIANT : Scope.CLASS));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            SharedSecrets.LOGGER.log(System.Logger.Level.WARNING, "Failed to create WithParser", (Throwable)e);
            return List.of();
        }
    }
}

