/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;

public class StringParser
extends ArgumentParser<String> {
    public static final String DEFAULT_KEYWORD = "string";

    @ApiStatus.AvailableSince(value="0.0.36")
    public StringParser(int priority, String keyword) {
        super(keyword, String.class, priority);
    }

    public StringParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<String>> parse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        return Optional.of(new ArgumentParser.ParseResult<String>(args.get(startIndex), startIndex + 1));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        int startIndex = processingContext.index();
        return OptionalInt.of(startIndex + 1);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        int startIndex = processingContext.index();
        return Optional.of(new ArgumentParser.TabCompletionResult(Set.of(), startIndex + 1));
    }
}

