/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.apartium.cocoabeans.StringHelpers;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.utils.OptionalFloat;
import org.jetbrains.annotations.ApiStatus;

public class FloatParser
extends ArgumentParser<Float> {
    public static final String DEFAULT_KEYWORD = "float";

    @ApiStatus.AvailableSince(value="0.0.36")
    public FloatParser(int priority, String keyword) {
        super(keyword, Float.TYPE, priority);
    }

    public FloatParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Float>> parse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OptionalFloat optionalFloat = StringHelpers.parseFloat((String)args.get(startIndex = processingContext.index()));
        if (optionalFloat.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.ParseResult<Float>(Float.valueOf(optionalFloat.getAsFloat()), startIndex + 1));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OptionalFloat optionalFloat = StringHelpers.parseFloat((String)args.get(startIndex = processingContext.index()));
        if (optionalFloat.isEmpty()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(startIndex + 1);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        int i;
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        boolean onlyZero = true;
        boolean hasDot = false;
        char[] charArray = args.get(startIndex).toCharArray();
        for (int i2 = 0; i2 < charArray.length; ++i2) {
            if (i2 == 0 && (charArray[0] == '-' || charArray[0] == '+')) continue;
            if (charArray[i2] >= '0' && charArray[i2] <= '9') {
                if (charArray[i2] == '0') continue;
                onlyZero = false;
                continue;
            }
            if (charArray[i2] == '.' && !hasDot) {
                hasDot = true;
                onlyZero = false;
                continue;
            }
            return Optional.empty();
        }
        HashSet<String> result = new HashSet<String>();
        int n = i = args.get(startIndex).isEmpty() || onlyZero ? 1 : 0;
        while (i < 10) {
            result.add(args.get(startIndex) + i);
            ++i;
        }
        if (!hasDot) {
            result.add(args.get(startIndex) + ".");
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, startIndex + 1));
    }
}

