/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.apartium.cocoabeans.StringHelpers;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;

public class DoubleParser
extends ArgumentParser<Double> {
    public static final String DEFAULT_KEYWORD = "double";

    @ApiStatus.AvailableSince(value="0.0.36")
    public DoubleParser(int priority, String keyword) {
        super(keyword, Double.TYPE, priority);
    }

    public DoubleParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Double>> parse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OptionalDouble optionalDouble = StringHelpers.parseDouble((String)args.get(startIndex = processingContext.index()));
        if (optionalDouble.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.ParseResult<Double>(optionalDouble.getAsDouble(), startIndex + 1));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OptionalDouble optionalDouble = StringHelpers.parseDouble((String)args.get(startIndex = processingContext.index()));
        if (optionalDouble.isEmpty()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(startIndex + 1);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        int i;
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        boolean onlyZero = true;
        boolean hasDot = false;
        char[] charArray = args.get(startIndex).toCharArray();
        for (int i2 = 0; i2 < charArray.length; ++i2) {
            if (i2 == 0 && (charArray[0] == '-' || charArray[0] == '+')) continue;
            if (charArray[i2] >= '0' && charArray[i2] <= '9') {
                if (charArray[i2] == '0') continue;
                onlyZero = false;
                continue;
            }
            if (charArray[i2] == '.' && !hasDot) {
                hasDot = true;
                onlyZero = false;
                continue;
            }
            return Optional.empty();
        }
        HashSet<String> result = new HashSet<String>();
        int n = i = args.get(startIndex).isEmpty() || onlyZero ? 1 : 0;
        while (i < 10) {
            result.add(args.get(startIndex) + i);
            ++i;
        }
        if (!hasDot) {
            result.add(args.get(startIndex) + ".");
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, startIndex + 1));
    }
}

