/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.RegisterArgumentParser;
import net.apartium.cocoabeans.commands.RegisteredVariant;
import net.apartium.cocoabeans.commands.SimpleCommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.CompoundParser;
import net.apartium.cocoabeans.commands.parsers.CompoundParserBranchProcessor;
import net.apartium.cocoabeans.structs.Entry;

class CompoundParserOption<T> {
    private final List<RegisteredVariant> registeredVariants = new ArrayList<RegisteredVariant>();
    final List<Entry<RegisterArgumentParser<?>, CompoundParserBranchProcessor<T>>> argumentTypeHandlerMap = new ArrayList();

    CompoundParserOption() {
    }

    public Optional<CompoundParser.ParserResult> parse(CommandProcessingContext processingContext) {
        if (processingContext.args().size() <= processingContext.index() || this.argumentTypeHandlerMap.isEmpty()) {
            if (!this.registeredVariants.isEmpty()) {
                return Optional.of(new CompoundParser.ParserResult(Collections.unmodifiableList(this.registeredVariants), processingContext.index(), new HashMap()));
            }
            return Optional.empty();
        }
        for (Entry<RegisterArgumentParser<?>, CompoundParserBranchProcessor<T>> entry : this.argumentTypeHandlerMap) {
            Optional<CompoundParser.ParserResult> result;
            Optional parse = ((RegisterArgumentParser)entry.key()).parse(processingContext);
            if (parse.isEmpty() || (result = ((CompoundParserBranchProcessor)entry.value()).parse(new SimpleCommandProcessingContext(processingContext.sender(), processingContext.label(), processingContext.args().toArray(new String[0]), parse.get().newIndex()))).isEmpty()) continue;
            result.get().mappedByClass().computeIfAbsent(((RegisterArgumentParser)entry.key()).getArgumentType(), clazz -> new ArrayList()).add(0, parse.get().result());
            return result;
        }
        if (!this.registeredVariants.isEmpty()) {
            return Optional.of(new CompoundParser.ParserResult(Collections.unmodifiableList(this.registeredVariants), processingContext.index(), new HashMap()));
        }
        return Optional.empty();
    }

    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        HashSet<String> result = new HashSet<String>();
        int highestIndex = -1;
        for (Entry<RegisterArgumentParser<?>, CompoundParserBranchProcessor<T>> entry : this.argumentTypeHandlerMap) {
            Optional<ArgumentParser.TabCompletionResult> parse = ((RegisterArgumentParser)entry.key()).tabCompletion(processingContext);
            if (parse.isEmpty()) continue;
            highestIndex = Math.max(highestIndex, parse.get().newIndex());
            result.addAll(parse.get().result());
        }
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, highestIndex));
    }

    public List<RegisteredVariant> getRegisteredVariants() {
        return this.registeredVariants;
    }
}

