/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.Dispensers;
import net.apartium.cocoabeans.commands.ArgumentContext;
import net.apartium.cocoabeans.commands.ArgumentMapper;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.EvaluationContext;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.RegisterArgumentParser;
import net.apartium.cocoabeans.commands.RegisteredVariant;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.exception.UnknownTokenException;
import net.apartium.cocoabeans.commands.lexer.ArgumentParserToken;
import net.apartium.cocoabeans.commands.lexer.CommandLexer;
import net.apartium.cocoabeans.commands.lexer.CommandToken;
import net.apartium.cocoabeans.commands.lexer.KeywordToken;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.CompoundParserBranchProcessor;
import net.apartium.cocoabeans.commands.parsers.CompoundParserOption;
import net.apartium.cocoabeans.commands.parsers.ParserFactory;
import net.apartium.cocoabeans.commands.parsers.ParserVariant;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirement;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirementFactory;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementSet;
import net.apartium.cocoabeans.structs.Entry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.37")
public class CompoundParser<T>
extends ArgumentParser<T>
implements GenericNode {
    private final Map<Class<? extends RequirementFactory>, RequirementFactory> requirementFactories = new HashMap<Class<? extends RequirementFactory>, RequirementFactory>();
    private final Map<Class<? extends ParserFactory>, ParserFactory> parserFactories = new HashMap<Class<? extends ParserFactory>, ParserFactory>();
    private final Map<Class<? extends ArgumentRequirementFactory>, ArgumentRequirementFactory> argumentRequirementFactories = new HashMap<Class<? extends ArgumentRequirementFactory>, ArgumentRequirementFactory>();
    private final Map<Class<? extends Annotation>, RequirementFactory> externalRequirementFactories;
    private final CompoundParserBranchProcessor<T> compoundParserBranchProcessor;
    private final ArgumentMapper argumentMapper;
    private final CommandLexer commandLexer;

    @Deprecated(since="0.0.38", forRemoval=true)
    protected CompoundParser(String keyword, Class<T> clazz, int priority, ArgumentMapper argumentMapper, CommandLexer commandLexer) {
        this(keyword, clazz, priority, new EvaluationContext(commandLexer, argumentMapper));
    }

    @ApiStatus.AvailableSince(value="0.0.38")
    protected CompoundParser(String keyword, Class<T> clazz, int priority, EvaluationContext evaluationContext) {
        super(keyword, clazz, priority);
        this.argumentMapper = evaluationContext.mapper();
        this.commandLexer = evaluationContext.lexer();
        this.compoundParserBranchProcessor = new CompoundParserBranchProcessor();
        this.externalRequirementFactories = evaluationContext.externalRequirementFactories();
        try {
            this.createBranch();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to create branch", e);
        }
        this.requirementFactories.clear();
        this.parserFactories.clear();
        this.argumentRequirementFactories.clear();
    }

    private void createBranch() throws IllegalAccessException {
        RequirementSet requirementsResult = RequirementFactory.createRequirementSet(this, this.getClass().getAnnotations(), this.requirementFactories, this.externalRequirementFactories);
        HashMap argumentParser = new HashMap();
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        CollectionHelpers.mergeInto(argumentParser, ParserFactory.findClassParsers(this, this.getClass(), this.parserFactories));
        for (Method method : this.getClass().getMethods()) {
            ParserVariant[] parserVariants = (ParserVariant[])method.getAnnotationsByType(ParserVariant.class);
            if (parserVariants.length == 0) continue;
            RequirementSet methodRequirements = new RequirementSet(RequirementFactory.createRequirementSet(this, method.getAnnotations(), this.requirementFactories, this.externalRequirementFactories), requirementsResult);
            HashMap methodArgumentTypeHandlerMap = new HashMap(argumentParser);
            methodArgumentTypeHandlerMap.putAll(ParserFactory.getArgumentParsers((GenericNode)this, method.getAnnotations(), (GenericDeclaration)method, false, this.parserFactories));
            RegisteredVariant.Parameter[] parameters = RegisteredVariant.Parameter.of(this, method.getParameters(), this.argumentRequirementFactories);
            method.setAccessible(true);
            MethodHandle unreflect = lookup.unreflect(method);
            for (ParserVariant parserVariant : parserVariants) {
                this.handleParserVariants(unreflect, parserVariant, methodRequirements, methodArgumentTypeHandlerMap, parameters, new ArrayList(), new ArrayList<Requirement>(methodRequirements));
            }
        }
    }

    private void handleParserVariants(MethodHandle method, ParserVariant parserVariant, RequirementSet requirementSet, Map<String, ArgumentParser<?>> argumentParserMap, RegisteredVariant.Parameter[] parameters, List<RegisterArgumentParser<?>> parsersResult, List<Requirement> requirementsResult) {
        List<CommandToken> tokens = this.commandLexer.tokenize(parserVariant.value());
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Parser variant cannot be empty");
        }
        CompoundParserOption<T> currentOption = this.findOrCreateOption(this.compoundParserBranchProcessor, requirementSet, new ArrayList<Requirement>());
        for (int i = 0; i < tokens.size(); ++i) {
            RequirementSet requirements;
            CommandToken token = tokens.get(i);
            RequirementSet requirementSet2 = requirements = i == 0 ? requirementSet : new RequirementSet();
            if (token instanceof KeywordToken) {
                throw new UnsupportedOperationException("Keyword tokens are not supported");
            }
            if (!(token instanceof ArgumentParserToken)) {
                throw new UnknownTokenException(token);
            }
            ArgumentParserToken argumentParserToken = (ArgumentParserToken)token;
            currentOption = this.createArgumentOption(currentOption, argumentParserToken, argumentParserMap, requirements, parsersResult, requirementsResult);
        }
        CollectionHelpers.addElementSorted(currentOption.getRegisteredVariants(), (Object)new RegisteredVariant(method, parameters, this, this.argumentMapper.mapIndices(parameters, parsersResult, requirementsResult, List.of()), parserVariant.priority()), RegisteredVariant.REGISTERED_VARIANT_COMPARATOR);
    }

    private CompoundParserOption<T> createArgumentOption(CompoundParserOption<T> option, ArgumentParserToken argumentParserToken, Map<String, ArgumentParser<?>> argumentTypeHandlerMap, RequirementSet requirements, List<RegisterArgumentParser<?>> parsersResult, List<Requirement> requirementsResult) {
        RegisterArgumentParser parser = argumentParserToken.getParser(argumentTypeHandlerMap);
        if (parser == null) {
            throw new IllegalArgumentException("Parser not found: " + argumentParserToken.getParserName());
        }
        Entry entryArgument = option.argumentTypeHandlerMap.stream().filter(entry -> ((RegisterArgumentParser)entry.key()).equals(parser)).findAny().orElse(null);
        CompoundParserBranchProcessor branchProcessor = entryArgument == null ? null : (CompoundParserBranchProcessor)entryArgument.value();
        parsersResult.add(entryArgument == null ? parser : (RegisterArgumentParser)entryArgument.key());
        if (branchProcessor == null) {
            branchProcessor = new CompoundParserBranchProcessor();
            CollectionHelpers.addElementSorted(option.argumentTypeHandlerMap, (Object)new Entry((Object)parser, branchProcessor), (a, b) -> ((RegisterArgumentParser)b.key()).compareTo((ArgumentParser)a.key()));
        }
        return this.findOrCreateOption(branchProcessor, requirements, requirementsResult);
    }

    @ApiStatus.Internal
    private CompoundParserOption<T> findOrCreateOption(CompoundParserBranchProcessor<T> branchProcessor, RequirementSet requirements, List<Requirement> requirementsResult) {
        for (Entry entry : branchProcessor.objectMap) {
            if (!((RequirementSet)entry.key()).equals(requirements)) continue;
            return (CompoundParserOption)entry.value();
        }
        CompoundParserOption option = new CompoundParserOption();
        branchProcessor.objectMap.add(new Entry((Object)requirements, option));
        requirementsResult.addAll(requirements);
        return option;
    }

    @ApiStatus.Internal
    private List<Object> getParameters(RegisteredVariant registeredVariant, Sender sender, ArgumentContext context) {
        ArrayList<Object> parameters = new ArrayList<Object>(registeredVariant.argumentIndexList().stream().map(argumentIndex -> argumentIndex.get(context)).toList());
        parameters.add(0, registeredVariant.node());
        for (int i = 0; i < registeredVariant.parameters().length; ++i) {
            Object obj = parameters.get(i + 1);
            for (ArgumentRequirement argumentRequirement : registeredVariant.parameters()[i].argumentRequirements()) {
                if (argumentRequirement.meetsRequirement(sender, null, obj)) continue;
                return null;
            }
        }
        return parameters;
    }

    @Override
    public Optional<ArgumentParser.ParseResult<T>> parse(CommandProcessingContext processingContext) {
        Optional<ParserResult> parse = this.compoundParserBranchProcessor.parse(processingContext);
        if (parse.isEmpty()) {
            processingContext.report(this, new BadCommandResponse(processingContext.label(), processingContext.args().toArray(new String[0]), processingContext.index(), "No variant found"));
            return Optional.empty();
        }
        for (RegisteredVariant registeredVariant : parse.get().registeredVariant()) {
            Object output;
            List<Object> parameters = this.getParameters(registeredVariant, processingContext.sender(), new ArgumentContext(processingContext.label(), processingContext.args().toArray(new String[0]), processingContext.sender(), parse.get().mappedByClass));
            if (parameters == null) continue;
            try {
                output = registeredVariant.method().invokeWithArguments(parameters);
            }
            catch (Throwable e) {
                Dispensers.dispense((Throwable)e);
                return Optional.empty();
            }
            if (output == null) continue;
            return Optional.of(new ArgumentParser.ParseResult<Object>(output, parse.get().newIndex));
        }
        processingContext.report(this, new BadCommandResponse(processingContext.label(), processingContext.args().toArray(new String[0]), processingContext.index(), "No variant found"));
        return Optional.empty();
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        return this.parse(processingContext).map(ArgumentParser.ParseResult::newIndex).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        return this.compoundParserBranchProcessor.tabCompletion(processingContext);
    }

    record ParserResult(List<RegisteredVariant> registeredVariant, int newIndex, Map<Class<?>, List<Object>> mappedByClass) {
    }
}

