/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.Dispensers;
import net.apartium.cocoabeans.commands.CommandBranchProcessor;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.CommandInfo;
import net.apartium.cocoabeans.commands.CommandManager;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.CommandOption;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.RegisterArgumentParser;
import net.apartium.cocoabeans.commands.RegisteredVariant;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.SubCommand;
import net.apartium.cocoabeans.commands.exception.ExceptionHandle;
import net.apartium.cocoabeans.commands.exception.HandleExceptionVariant;
import net.apartium.cocoabeans.commands.exception.UnknownTokenException;
import net.apartium.cocoabeans.commands.lexer.ArgumentParserToken;
import net.apartium.cocoabeans.commands.lexer.CommandToken;
import net.apartium.cocoabeans.commands.lexer.KeywordToken;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.ParserFactory;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementSet;
import net.apartium.cocoabeans.commands.virtual.VirtualCommandDefinition;
import net.apartium.cocoabeans.commands.virtual.VirtualCommandVariant;
import net.apartium.cocoabeans.reflect.ClassUtils;
import net.apartium.cocoabeans.reflect.MethodUtils;
import net.apartium.cocoabeans.structs.Entry;

class RegisteredCommand {
    private static final Comparator<HandleExceptionVariant> HANDLE_EXCEPTION_VARIANT_COMPARATOR = (a, b) -> Integer.compare(b.priority(), a.priority());
    private final CommandManager commandManager;
    private final List<RegisteredCommandNode> commands = new ArrayList<RegisteredCommandNode>();
    private final List<VirtualCommandNode> virtualNodes = new ArrayList<VirtualCommandNode>();
    private final List<HandleExceptionVariant> handleExceptionVariants = new ArrayList<HandleExceptionVariant>();
    private final CommandBranchProcessor commandBranchProcessor;
    private final CommandInfo commandInfo = new CommandInfo();

    RegisteredCommand(CommandManager commandManager) {
        this.commandManager = commandManager;
        this.commandBranchProcessor = new CommandBranchProcessor(commandManager);
    }

    public void addNode(CommandNode node) {
        Method fallbackHandle;
        Class<?> clazz = node.getClass();
        this.commandInfo.fromAnnotations(clazz.getAnnotations(), false);
        RequirementSet requirementSet = new RequirementSet(this.findAllRequirements(node, clazz));
        try {
            fallbackHandle = clazz.getMethod("fallbackHandle", Sender.class, String.class, String[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("What is going on here", e);
        }
        this.commands.add(new RegisteredCommandNode(node, new RequirementSet(requirementSet, RequirementFactory.createRequirementSet(node, fallbackHandle.getAnnotations(), this.commandManager.requirementFactories, this.commandManager.getExternalRequirementFactories()))));
        HashMap argumentTypeHandlerMap = new HashMap();
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        CollectionHelpers.mergeInto(argumentTypeHandlerMap, ParserFactory.findClassParsers(node, clazz, this.commandManager.parserFactories));
        CollectionHelpers.mergeInto(argumentTypeHandlerMap, this.commandManager.argumentTypeHandlerMap);
        ArrayList<Requirement> classRequirementsResult = new ArrayList<Requirement>();
        CommandOption commandOption = this.createCommandOption(requirementSet, this.commandBranchProcessor, classRequirementsResult);
        for (Method method : MethodUtils.getAllMethods(clazz)) {
            SubCommand[] subCommands = (SubCommand[])method.getAnnotationsByType(SubCommand.class);
            for (SubCommand subCommand : subCommands) {
                try {
                    this.parseSubCommand(new ParserSubCommandContext(method, subCommand, clazz, node, commandOption, argumentTypeHandlerMap, requirementSet), publicLookup, new ArrayList(), new ArrayList<Requirement>(classRequirementsResult));
                }
                catch (IllegalAccessException e) {
                    Dispensers.dispense((Throwable)e);
                    return;
                }
            }
            try {
                this.serializeExceptionHandles(method, node, publicLookup);
            }
            catch (IllegalAccessException e) {
                Dispensers.dispense((Throwable)e);
                return;
            }
            for (Method targetMethod : MethodUtils.getMethodsFromSuperClassAndInterface((Method)method)) {
                try {
                    this.handleSubCommand(new ParserSubCommandContext(method, null, clazz, node, commandOption, argumentTypeHandlerMap, requirementSet), publicLookup, targetMethod, classRequirementsResult);
                }
                catch (IllegalAccessException e) {
                    Dispensers.dispense((Throwable)e);
                    return;
                }
            }
        }
    }

    private RequirementSet getVirtualRequirement(Map<String, Object> metadata) {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        for (Function<Map<String, Object>, Set<Requirement>> metadataHandler : this.commandManager.getMetadataHandlers()) {
            Set<Requirement> apply = metadataHandler.apply(metadata);
            if (apply == null) continue;
            requirements.addAll(apply);
        }
        return new RequirementSet(requirements);
    }

    public void addVirtualCommand(VirtualCommandDefinition virtualCommandDefinition, Function<CommandContext, Boolean> callback) {
        this.commandInfo.fromCommandInfo(virtualCommandDefinition.info());
        this.virtualNodes.add(new VirtualCommandNode(virtualCommandDefinition, callback));
        ArrayList<Requirement> classRequirementsResult = new ArrayList<Requirement>();
        CommandOption virtualOption = this.createCommandOption(this.getVirtualRequirement(virtualCommandDefinition.metadata()), this.commandBranchProcessor, classRequirementsResult);
        ArrayList parsersResult = new ArrayList();
        for (VirtualCommandVariant variant : virtualCommandDefinition.variants()) {
            List<CommandToken> tokens = this.commandManager.getCommandLexer().tokenize(variant.variant());
            CommandOption currentOption = virtualOption;
            RequirementSet methodRequirements = this.getVirtualRequirement(variant.metadata());
            for (int i = 0; i < tokens.size(); ++i) {
                CommandToken token = tokens.get(i);
                if (token instanceof KeywordToken) {
                    KeywordToken keywordToken = (KeywordToken)token;
                    currentOption = this.createKeywordOption(currentOption, variant.ignoreCase(), keywordToken, this.resolveRequirementsForBranch(i, methodRequirements), classRequirementsResult);
                    continue;
                }
                if (token instanceof ArgumentParserToken) {
                    ArgumentParserToken argumentParserToken = (ArgumentParserToken)token;
                    currentOption = this.createArgumentOption(currentOption, argumentParserToken, this.commandManager.argumentTypeHandlerMap, this.resolveRequirementsForBranch(i, methodRequirements), parsersResult, classRequirementsResult);
                    continue;
                }
                throw new UnknownTokenException(token);
            }
        }
    }

    private void serializeExceptionHandles(Method method, CommandNode node, MethodHandles.Lookup publicLookup) throws IllegalAccessException {
        for (Method targetMethod : Stream.concat(Stream.of(method), MethodUtils.getMethodsFromSuperClassAndInterface((Method)method).stream()).toList()) {
            ExceptionHandle exceptionHandle = targetMethod.getAnnotation(ExceptionHandle.class);
            if (exceptionHandle == null) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalAccessException("Method " + method.getName() + "#" + node.getClass().getSimpleName() + " is not public");
            }
            CollectionHelpers.addElementSorted(this.handleExceptionVariants, (Object)this.getHandleExceptionVariant(node, method, exceptionHandle, publicLookup), HANDLE_EXCEPTION_VARIANT_COMPARATOR);
        }
    }

    private HandleExceptionVariant getHandleExceptionVariant(GenericNode node, Method method, ExceptionHandle exceptionHandle, MethodHandles.Lookup publicLookup) {
        RegisteredVariant.Parameter[] parameters = RegisteredVariant.Parameter.of(node, method.getParameters(), this.commandManager.argumentRequirementFactories);
        ArrayList additionalTypes = new ArrayList(List.of(exceptionHandle.value()));
        try {
            return new HandleExceptionVariant(exceptionHandle.value(), publicLookup.unreflect(method), (Class[])Arrays.stream(method.getParameters()).map(Parameter::getType).toArray(Class[]::new), node, this.commandManager.getArgumentMapper().mapIndices(parameters, List.of(), List.of(), additionalTypes), exceptionHandle.priority());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleSubCommand(ParserSubCommandContext context, MethodHandles.Lookup publicLookup, Method targetMethod, List<Requirement> classRequirementsResult) throws IllegalAccessException {
        SubCommand[] superSubCommands;
        if (targetMethod == null) {
            return;
        }
        for (SubCommand subCommand : superSubCommands = (SubCommand[])targetMethod.getAnnotationsByType(SubCommand.class)) {
            this.parseSubCommand(new ParserSubCommandContext(context.method, subCommand, context.clazz, context.commandNode, context.commandOption, context.argumentTypeHandlerMap, context.requirementSet), publicLookup, new ArrayList(), new ArrayList<Requirement>(classRequirementsResult));
        }
        ExceptionHandle exceptionHandle = targetMethod.getAnnotation(ExceptionHandle.class);
        if (exceptionHandle != null) {
            CollectionHelpers.addElementSorted(this.handleExceptionVariants, (Object)this.getHandleExceptionVariant(context.commandNode, context.method, exceptionHandle, publicLookup), HANDLE_EXCEPTION_VARIANT_COMPARATOR);
        }
    }

    private void parseSubCommand(ParserSubCommandContext context, MethodHandles.Lookup publicLookup, List<RegisterArgumentParser<?>> parsersResult, List<Requirement> requirementsResult) throws IllegalAccessException {
        if (context.subCommand == null) {
            return;
        }
        if (!Modifier.isPublic(context.method.getModifiers())) {
            throw new IllegalAccessException("Method " + context.clazz.getName() + "#" + context.method.getName() + " is not public");
        }
        if (Modifier.isStatic(context.method.getModifiers())) {
            throw new IllegalAccessException("Static method " + context.clazz.getName() + "#" + context.method.getName() + " is not supported");
        }
        HashMap methodArgumentTypeHandlerMap = new HashMap(ParserFactory.getArgumentParsers((GenericNode)context.commandNode, context.method.getAnnotations(), (GenericDeclaration)context.method, false, this.commandManager.parserFactories));
        for (Method targetMethod : MethodUtils.getMethodsFromSuperClassAndInterface((Method)context.method)) {
            CollectionHelpers.mergeInto(methodArgumentTypeHandlerMap, ParserFactory.getArgumentParsers((GenericNode)context.commandNode, targetMethod.getAnnotations(), (GenericDeclaration)targetMethod, false, this.commandManager.parserFactories));
        }
        CollectionHelpers.mergeInto(methodArgumentTypeHandlerMap, context.argumentTypeHandlerMap);
        CommandInfo methodInfo = this.generateCommandInfo(context.method);
        RequirementSet methodRequirements = new RequirementSet(this.findAllRequirements(context.commandNode, context.method), context.requirementSet);
        String[] split = context.subCommand.value().split("\\s+");
        if (this.isEmptyArgs(split)) {
            CommandOption cmdOption = this.createCommandOption(methodRequirements, this.commandBranchProcessor, requirementsResult);
            cmdOption.getCommandInfo().fromCommandInfo(methodInfo);
            RegisteredVariant.Parameter[] parameters = RegisteredVariant.Parameter.of(context.commandNode, context.method.getParameters(), this.commandManager.argumentRequirementFactories);
            try {
                CollectionHelpers.addElementSorted(cmdOption.getRegisteredCommandVariants(), (Object)new RegisteredVariant(publicLookup.unreflect(context.method), parameters, context.commandNode, this.commandManager.getArgumentMapper().mapIndices(parameters, parsersResult, requirementsResult, List.of()), context.subCommand.priority()), RegisteredVariant.REGISTERED_VARIANT_COMPARATOR);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing method", e);
            }
            catch (NoSuchElementException e) {
                throw new NoSuchElementException("There is an misused parameter for the following method " + context.clazz.getName() + "#" + context.method.getName() + "\nSub command value: " + context.subCommand.value(), e);
            }
            return;
        }
        CommandOption currentCommandOption = context.commandOption;
        List<CommandToken> tokens = this.commandManager.getCommandLexer().tokenize(context.subCommand.value());
        for (int i = 0; i < tokens.size(); ++i) {
            CommandToken token = tokens.get(i);
            RequirementSet requirements = this.resolveRequirementsForBranch(i, methodRequirements);
            if (token instanceof KeywordToken) {
                KeywordToken keywordToken = (KeywordToken)token;
                currentCommandOption = this.createKeywordOption(currentCommandOption, context.subCommand.ignoreCase(), keywordToken, requirements, requirementsResult);
                continue;
            }
            if (token instanceof ArgumentParserToken) {
                ArgumentParserToken argumentParserToken = (ArgumentParserToken)token;
                currentCommandOption = this.createArgumentOption(currentCommandOption, argumentParserToken, methodArgumentTypeHandlerMap, requirements, parsersResult, requirementsResult);
                continue;
            }
            throw new UnknownTokenException(token);
        }
        currentCommandOption.getCommandInfo().fromCommandInfo(methodInfo);
        RegisteredVariant.Parameter[] parameters = RegisteredVariant.Parameter.of(context.commandNode, context.method.getParameters(), this.commandManager.argumentRequirementFactories);
        try {
            CollectionHelpers.addElementSorted(currentCommandOption.getRegisteredCommandVariants(), (Object)new RegisteredVariant(publicLookup.unreflect(context.method), parameters, context.commandNode, this.commandManager.getArgumentMapper().mapIndices(parameters, parsersResult, requirementsResult, List.of()), context.subCommand.priority()), RegisteredVariant.REGISTERED_VARIANT_COMPARATOR);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("There is an misused parameter for the following method " + context.clazz.getName() + "#" + context.method.getName() + "\nSub command value: " + context.subCommand.value(), e);
        }
    }

    private RequirementSet resolveRequirementsForBranch(int index, RequirementSet methodRequirements) {
        return index == 0 ? methodRequirements : new RequirementSet();
    }

    private boolean isEmptyArgs(String[] split) {
        return split.length == 0 || split.length == 1 && split[0].isEmpty();
    }

    private CommandInfo generateCommandInfo(Method method) {
        CommandInfo info = new CommandInfo();
        info.fromAnnotations(method.getAnnotations(), true);
        for (Method targetMethod : MethodUtils.getMethodsFromSuperClassAndInterface((Method)method)) {
            info.fromAnnotations(targetMethod.getAnnotations(), false);
        }
        return info;
    }

    private CommandOption createKeywordOption(CommandOption currentCommandOption, boolean ignoreCase, KeywordToken keywordToken, RequirementSet requirements, List<Requirement> requirementsResult) {
        Map<String, CommandBranchProcessor> keywordMap = ignoreCase ? currentCommandOption.getKeywordIgnoreCaseMap() : currentCommandOption.getKeywordMap();
        String keyword = ignoreCase ? keywordToken.getKeyword().toLowerCase() : keywordToken.getKeyword();
        CommandBranchProcessor branchProcessor = keywordMap.computeIfAbsent(keyword, key -> new CommandBranchProcessor(this.commandManager));
        return this.createCommandOption(requirements, branchProcessor, requirementsResult);
    }

    private CommandOption createArgumentOption(CommandOption currentCommandOption, ArgumentParserToken argumentParserToken, Map<String, ArgumentParser<?>> parserMap, RequirementSet requirements, List<RegisterArgumentParser<?>> parsersResult, List<Requirement> requirementsResult) {
        CommandBranchProcessor branchProcessor;
        CommandBranchProcessor commandBranchProcessor;
        RegisterArgumentParser parser = argumentParserToken.getParser(parserMap);
        if (parser == null) {
            throw new IllegalArgumentException("Parser not found: " + argumentParserToken.getParserName());
        }
        Entry entryArgument = currentCommandOption.getArgumentTypeHandlerMap().stream().filter(entry -> ((RegisterArgumentParser)entry.key()).equals(parser)).findAny().orElse(null);
        CommandBranchProcessor commandBranchProcessor2 = commandBranchProcessor = entryArgument == null ? null : (CommandBranchProcessor)entryArgument.value();
        if (commandBranchProcessor == null) {
            commandBranchProcessor = new CommandBranchProcessor(this.commandManager);
            CollectionHelpers.addElementSorted(currentCommandOption.getArgumentTypeHandlerMap(), (Object)new Entry((Object)parser, (Object)commandBranchProcessor), (a, b) -> ((RegisterArgumentParser)b.key()).compareTo((ArgumentParser)a.key()));
        }
        parsersResult.add(entryArgument == null ? parser : (RegisterArgumentParser)entryArgument.key());
        if (parser.isOptional() && (branchProcessor = (CommandBranchProcessor)currentCommandOption.getOptionalArgumentTypeHandlerMap().stream().filter(entry -> ((RegisterArgumentParser)entry.key()).equals(parser)).findAny().map(Entry::value).orElse(null)) == null) {
            branchProcessor = commandBranchProcessor;
            CollectionHelpers.addElementSorted(currentCommandOption.getOptionalArgumentTypeHandlerMap(), (Object)new Entry((Object)parser, (Object)branchProcessor), (a, b) -> ((RegisterArgumentParser)b.key()).compareTo((ArgumentParser)a.key()));
        }
        return this.createCommandOption(requirements, commandBranchProcessor, requirementsResult);
    }

    private CommandOption createCommandOption(RequirementSet requirements, CommandBranchProcessor branchProcessor, List<Requirement> requirementsResult) {
        CommandOption cmdOption = branchProcessor.objectMap.stream().filter(entry -> ((RequirementSet)entry.key()).equals(requirements)).findAny().map(Entry::value).orElse(null);
        if (cmdOption == null) {
            cmdOption = new CommandOption(this.commandManager);
            branchProcessor.objectMap.add((Entry<RequirementSet, CommandOption>)new Entry((Object)requirements, (Object)cmdOption));
        }
        requirementsResult.addAll(requirements);
        return cmdOption;
    }

    private Set<Requirement> findAllRequirements(CommandNode commandNode, Class<?> clazz) {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        for (Class c : ClassUtils.getSuperClassAndInterfaces(clazz)) {
            requirements.addAll(RequirementFactory.createRequirementSet(commandNode, c.getAnnotations(), this.commandManager.requirementFactories, this.commandManager.getExternalRequirementFactories()));
        }
        return requirements;
    }

    private Set<Requirement> findAllRequirements(CommandNode commandNode, Method method) {
        HashSet<Requirement> requirements = new HashSet<Requirement>(RequirementFactory.createRequirementSet(commandNode, method.getAnnotations(), this.commandManager.requirementFactories, this.commandManager.getExternalRequirementFactories()));
        for (Method target : MethodUtils.getMethodsFromSuperClassAndInterface((Method)method)) {
            requirements.addAll(RequirementFactory.createRequirementSet(commandNode, target.getAnnotations(), this.commandManager.requirementFactories, this.commandManager.getExternalRequirementFactories()));
        }
        return requirements;
    }

    public CommandInfo getCommandInfo() {
        return this.commandInfo;
    }

    public List<RegisteredCommandNode> getCommands() {
        return this.commands;
    }

    public List<VirtualCommandNode> getVirtualNodes() {
        return this.virtualNodes;
    }

    public CommandBranchProcessor getCommandBranchProcessor() {
        return this.commandBranchProcessor;
    }

    public Iterable<HandleExceptionVariant> getHandleExceptionVariants() {
        return this.handleExceptionVariants;
    }

    public record RegisteredCommandNode(CommandNode listener, RequirementSet requirements) {
    }

    record ParserSubCommandContext(Method method, SubCommand subCommand, Class<?> clazz, CommandNode commandNode, CommandOption commandOption, Map<String, ArgumentParser<?>> argumentTypeHandlerMap, RequirementSet requirementSet) {
    }

    public record VirtualCommandNode(VirtualCommandDefinition command, Function<CommandContext, Boolean> callback) {
    }
}

