/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.apartium.cocoabeans.Dispensers;
import net.apartium.cocoabeans.commands.ArgumentContext;
import net.apartium.cocoabeans.commands.ArgumentMapper;
import net.apartium.cocoabeans.commands.Command;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.CommandInfo;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.RegisteredCommand;
import net.apartium.cocoabeans.commands.RegisteredVariant;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.exception.CommandException;
import net.apartium.cocoabeans.commands.exception.HandleExceptionVariant;
import net.apartium.cocoabeans.commands.exception.UnknownCommandResponse;
import net.apartium.cocoabeans.commands.lexer.CommandLexer;
import net.apartium.cocoabeans.commands.lexer.SimpleCommandLexer;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.BooleanParser;
import net.apartium.cocoabeans.commands.parsers.DoubleParser;
import net.apartium.cocoabeans.commands.parsers.FloatParser;
import net.apartium.cocoabeans.commands.parsers.IntParser;
import net.apartium.cocoabeans.commands.parsers.LongParser;
import net.apartium.cocoabeans.commands.parsers.ParserFactory;
import net.apartium.cocoabeans.commands.parsers.StringParser;
import net.apartium.cocoabeans.commands.parsers.StringsParser;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirement;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirementFactory;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import net.apartium.cocoabeans.commands.virtual.VirtualCommandDefinition;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public abstract class CommandManager {
    public static final Set<ArgumentParser<?>> COMMON_PARSERS = Set.of(new IntParser(0), new LongParser(0), new FloatParser(0), new DoubleParser(0), new BooleanParser(0), new StringParser(0), new StringsParser(0));
    protected final Map<String, RegisteredCommand> commandMap = new HashMap<String, RegisteredCommand>();
    private final ArgumentMapper argumentMapper;
    private final CommandLexer commandLexer;
    final Map<Class<? extends ParserFactory>, ParserFactory> parserFactories = new HashMap<Class<? extends ParserFactory>, ParserFactory>();
    final Map<Class<? extends ArgumentRequirementFactory>, ArgumentRequirementFactory> argumentRequirementFactories = new HashMap<Class<? extends ArgumentRequirementFactory>, ArgumentRequirementFactory>();
    final Map<Class<? extends RequirementFactory>, RequirementFactory> requirementFactories = new HashMap<Class<? extends RequirementFactory>, RequirementFactory>();
    private final Map<Class<? extends Annotation>, RequirementFactory> externalRequirementFactories = new HashMap<Class<? extends Annotation>, RequirementFactory>();
    private final List<Function<Map<String, Object>, Set<Requirement>>> metadataHandlers = new ArrayList<Function<Map<String, Object>, Set<Requirement>>>();
    final Map<String, ArgumentParser<?>> argumentTypeHandlerMap = new HashMap();

    protected CommandManager(ArgumentMapper argumentMapper) {
        this(argumentMapper, new SimpleCommandLexer());
    }

    protected CommandManager(ArgumentMapper argumentMapper, CommandLexer commandLexer) {
        this.argumentMapper = argumentMapper;
        this.commandLexer = commandLexer;
    }

    public void registerArgumentTypeHandler(ArgumentParser<?> argumentTypeHandler) {
        this.argumentTypeHandlerMap.put(argumentTypeHandler.getKeyword(), argumentTypeHandler);
    }

    public void registerArgumentTypeHandler(Set<ArgumentParser<?>> argumentTypeHandlers) {
        for (ArgumentParser<?> argumentTypeHandler : argumentTypeHandlers) {
            this.registerArgumentTypeHandler(argumentTypeHandler);
        }
    }

    @ApiStatus.AvailableSince(value="0.0.38")
    public void registerRequirementFactory(Class<? extends Annotation> annotation, RequirementFactory factory) {
        this.externalRequirementFactories.put(annotation, factory);
    }

    public List<String> handleTabComplete(Sender sender, String commandName, String[] args) {
        RegisteredCommand registeredCommand = this.commandMap.get(commandName.toLowerCase());
        if (registeredCommand == null) {
            return List.of();
        }
        if (args.length == 0) {
            args = new String[]{};
        }
        return registeredCommand.getCommandBranchProcessor().handleTabCompletion(registeredCommand, commandName, args, sender, 0).stream().toList();
    }

    public boolean handle(Sender sender, String commandName, String[] args) throws Throwable {
        RegisteredCommand registeredCommand = this.commandMap.get(commandName.toLowerCase());
        if (registeredCommand == null) {
            throw new UnknownCommandResponse(commandName).getError();
        }
        CommandContext context = registeredCommand.getCommandBranchProcessor().handle(registeredCommand, commandName, args, sender, 0);
        if (context == null) {
            return this.handleNullContext(sender, commandName, args, registeredCommand);
        }
        if (context.hasError()) {
            if (this.handleError(context, sender, commandName, args, registeredCommand, context.error().getError())) {
                return true;
            }
            context.error().throwError();
            return false;
        }
        for (RegisteredVariant method : context.option().getRegisteredCommandVariants()) {
            try {
                if (!this.invoke(context, sender, method)) continue;
                return true;
            }
            catch (Exception e) {
                if (this.handleError(context, sender, commandName, args, registeredCommand, e)) {
                    return true;
                }
                throw e;
            }
        }
        return this.handleFallback(sender, commandName, args, registeredCommand);
    }

    private boolean handleNullContext(Sender sender, String commandName, String[] args, RegisteredCommand registeredCommand) throws Exception {
        BadCommandResponse badCommandResponse = null;
        for (RegisteredCommand.RegisteredCommandNode listener : registeredCommand.getCommands()) {
            RequirementResult requirementResult = listener.requirements().meetsRequirements(new RequirementEvaluationContext(sender, commandName, args, 0));
            if (!requirementResult.hasError()) continue;
            badCommandResponse = requirementResult.getError();
            break;
        }
        if (this.handleFallback(sender, commandName, args, registeredCommand)) {
            return true;
        }
        if (badCommandResponse != null) {
            if (this.handleError(null, sender, commandName, args, registeredCommand, badCommandResponse.getError())) {
                return true;
            }
            badCommandResponse.throwError();
            return false;
        }
        return false;
    }

    private boolean handleFallback(Sender sender, String commandName, String[] args, RegisteredCommand registeredCommand) {
        for (RegisteredCommand.RegisteredCommandNode listener : registeredCommand.getCommands()) {
            if (!listener.listener().fallbackHandle(sender, commandName, args)) continue;
            return true;
        }
        CommandContext context = new CommandContext(sender, registeredCommand.getCommandInfo(), null, null, args, commandName, Map.of());
        for (RegisteredCommand.VirtualCommandNode virtualNode : registeredCommand.getVirtualNodes()) {
            if (!virtualNode.callback().apply(context).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean handleError(CommandContext context, Sender sender, String commandName, String[] args, RegisteredCommand registeredCommand, Throwable error) {
        for (HandleExceptionVariant handleExceptionVariant : registeredCommand.getHandleExceptionVariants()) {
            if (!handleExceptionVariant.exceptionType().isAssignableFrom(error.getClass()) || !this.invokeException(handleExceptionVariant, context, sender, commandName, args, error)) continue;
            return true;
        }
        for (RegisteredCommand.RegisteredCommandNode listener : registeredCommand.getCommands()) {
            if (!listener.listener().handleException(sender, commandName, args, error)) continue;
            return true;
        }
        return this.handleFallback(sender, commandName, args, registeredCommand);
    }

    private boolean invokeException(HandleExceptionVariant handleExceptionVariant, CommandContext context, Sender sender, String commandName, String[] args, Throwable throwable) {
        Object output;
        HashMap parsedArgs = new HashMap(Map.of(Throwable.class, List.of(throwable), CommandContext.class, List.of(context)));
        if (throwable instanceof CommandException) {
            CommandException commandException = (CommandException)throwable;
            parsedArgs.put(BadCommandResponse.class, List.of(commandException.getBadCommandResponse()));
            parsedArgs.put(throwable.getClass(), List.of(throwable));
        }
        ArgumentContext argumentContext = new ArgumentContext(commandName, args, sender, parsedArgs);
        ArrayList<Object> parameters = new ArrayList<Object>(handleExceptionVariant.argumentIndexList().stream().map(argumentIndex -> argumentIndex.get(argumentContext)).toList());
        parameters.add(0, handleExceptionVariant.node());
        try {
            output = handleExceptionVariant.method().invokeWithArguments(parameters);
        }
        catch (Throwable e) {
            Dispensers.dispense((Throwable)e);
            return false;
        }
        if (output != null && output.getClass().equals(Boolean.class)) {
            return (Boolean)output;
        }
        return true;
    }

    private boolean invoke(CommandContext context, Sender sender, RegisteredVariant registeredVariant) {
        Object output;
        ArrayList<Object> parameters = new ArrayList<Object>(registeredVariant.argumentIndexList().stream().map(argumentIndex -> argumentIndex.get(context.toArgumentContext())).toList());
        parameters.add(0, registeredVariant.node());
        for (int i = 0; i < registeredVariant.parameters().length; ++i) {
            Object obj = parameters.get(i + 1);
            for (ArgumentRequirement argumentRequirement : registeredVariant.parameters()[i].argumentRequirements()) {
                if (argumentRequirement.meetsRequirement(sender, context, obj)) continue;
                return false;
            }
        }
        try {
            output = registeredVariant.method().invokeWithArguments(parameters);
        }
        catch (Throwable e) {
            Dispensers.dispense((Throwable)e);
            return false;
        }
        if (output != null && output.getClass().equals(Boolean.class)) {
            return (Boolean)output;
        }
        return true;
    }

    public void addCommand(CommandNode commandNode) {
        if (commandNode == null) {
            return;
        }
        Class<?> c = commandNode.getClass();
        Command handler = c.getAnnotation(Command.class);
        if (handler == null) {
            return;
        }
        RegisteredCommand registeredCommand = this.commandMap.computeIfAbsent(handler.value().toLowerCase(), cmd -> new RegisteredCommand(this));
        registeredCommand.addNode(commandNode);
        for (String alias : handler.aliases()) {
            this.commandMap.computeIfAbsent(alias.toLowerCase(), cmd -> new RegisteredCommand(this)).addNode(commandNode);
        }
        this.addCommand(commandNode, handler);
    }

    @ApiStatus.AvailableSince(value="0.0.39")
    public void addMetadataHandler(Function<Map<String, Object>, Set<Requirement>> metaDataHandler) {
        this.metadataHandlers.add(metaDataHandler);
    }

    @ApiStatus.AvailableSince(value="0.0.39")
    public void addVirtualCommand(VirtualCommandDefinition virtualCommandDefinition, Function<CommandContext, Boolean> callback) {
        if (virtualCommandDefinition == null || callback == null) {
            return;
        }
        this.commandMap.computeIfAbsent(virtualCommandDefinition.name(), cmd -> new RegisteredCommand(this)).addVirtualCommand(virtualCommandDefinition, callback);
        for (String alias : virtualCommandDefinition.aliases()) {
            this.commandMap.computeIfAbsent(alias.toLowerCase(), cmd -> new RegisteredCommand(this)).addVirtualCommand(virtualCommandDefinition, callback);
        }
    }

    public CommandInfo getCommandInfo(String commandName) {
        RegisteredCommand registeredCommand = this.commandMap.get(commandName.toLowerCase());
        if (registeredCommand == null) {
            return null;
        }
        return registeredCommand.getCommandInfo();
    }

    protected abstract void addCommand(CommandNode var1, Command var2);

    public ArgumentMapper getArgumentMapper() {
        return this.argumentMapper;
    }

    public CommandLexer getCommandLexer() {
        return this.commandLexer;
    }

    List<Function<Map<String, Object>, Set<Requirement>>> getMetadataHandlers() {
        return Collections.unmodifiableList(this.metadataHandlers);
    }

    @ApiStatus.Internal
    Map<Class<? extends Annotation>, RequirementFactory> getExternalRequirementFactories() {
        return Collections.unmodifiableMap(this.externalRequirementFactories);
    }
}

