/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.apartium.cocoabeans.commands.Description;
import net.apartium.cocoabeans.commands.LongDescription;
import net.apartium.cocoabeans.commands.Usage;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.30")
public class CommandInfo {
    private final List<String> descriptions = new ArrayList<String>();
    private final List<String> usages = new ArrayList<String>();
    private final List<String[]> longDescriptions = new ArrayList<String[]>();

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.descriptions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.descriptions.get(0));
    }

    @JsonIgnore
    public Optional<String> getUsage() {
        if (this.usages.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.usages.get(0));
    }

    @JsonIgnore
    public Optional<String[]> getLongDescription() {
        if (this.longDescriptions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.longDescriptions.get(0));
    }

    public List<String> getDescriptions() {
        return Collections.unmodifiableList(this.descriptions);
    }

    public List<String> getUsages() {
        return Collections.unmodifiableList(this.usages);
    }

    public List<String[]> getLongDescriptions() {
        return Collections.unmodifiableList(this.longDescriptions);
    }

    void addDescription(Description description, boolean first) {
        if (first) {
            this.descriptions.add(0, description.value());
            return;
        }
        this.descriptions.add(description.value());
    }

    void addUsage(Usage usage, boolean first) {
        if (first) {
            this.usages.add(0, usage.value());
            return;
        }
        this.usages.add(usage.value());
    }

    void addLongDescription(LongDescription longDescription, boolean first) {
        if (first) {
            this.longDescriptions.add(0, longDescription.value());
            return;
        }
        this.longDescriptions.add(longDescription.value());
    }

    void fromAnnotations(Annotation[] annotations, boolean first) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof Description) {
                Description description = (Description)annotation;
                this.addDescription(description, first);
                continue;
            }
            if (annotation instanceof Usage) {
                Usage usage = (Usage)annotation;
                this.addUsage(usage, first);
                continue;
            }
            if (!(annotation instanceof LongDescription)) continue;
            LongDescription longDescription = (LongDescription)annotation;
            this.addLongDescription(longDescription, first);
        }
    }

    void fromCommandInfo(CommandInfo other) {
        this.descriptions.addAll(other.descriptions);
        this.usages.addAll(other.usages);
        this.longDescriptions.addAll(other.longDescriptions);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandInfo that = (CommandInfo)o;
        return Objects.equals(this.descriptions, that.descriptions) && Objects.equals(this.usages, that.usages) && Objects.equals(this.longDescriptions, that.longDescriptions);
    }

    public int hashCode() {
        return Objects.hash(this.descriptions, this.usages, this.longDescriptions);
    }

    @JsonIgnore
    public static CommandInfo createFromAnnotations(Collection<Annotation[]> collection) {
        CommandInfo info = new CommandInfo();
        for (Annotation[] annotations : collection) {
            info.fromAnnotations(annotations, false);
        }
        return info;
    }
}

