/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.TestCommandProcessingContext;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.Assertions;

@ApiStatus.AvailableSince(value="0.0.36")
public class ParserAssertions {
    public static void assertParserResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, ArgumentParser.ParseResult<?> expected) {
        ParserAssertions.assertParserResult(parser, sender, label, args, 0, expected);
    }

    public static void assertParserResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, ArgumentParser.ParseResult<?> expected) {
        ParserAssertions.assertParserResult(parser, sender, label, args, startIndex, expected, null);
    }

    public static void assertParserResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, ArgumentParser.ParseResult<?> expected, String message) {
        ParserAssertions.assertParserResult(parser, new TestCommandProcessingContext(sender, label, List.of(args), startIndex), expected, message);
    }

    public static void assertParserResult(ArgumentParser<?> parser, CommandProcessingContext processingContext, ArgumentParser.ParseResult<?> expected, String message) {
        TestCommandProcessingContext context = new TestCommandProcessingContext(processingContext.sender(), processingContext.label(), processingContext.args(), processingContext.index());
        Optional parse = parser.parse((CommandProcessingContext)context);
        if (parse.isEmpty()) {
            if (!context.hasAnyReports()) {
                ParserAssertions.failMessage("Parser did not return a result or report any errors", message, expected, null);
                return;
            }
            List<BadCommandResponse> reports = context.getReports();
            ParserAssertions.failMessage("Parser failed with " + reports.size() + " report" + (reports.size() == 1 ? "" : "s"), message, expected, reports);
            return;
        }
        if (context.hasAnyReports()) {
            List<BadCommandResponse> reports = context.getReports();
            ParserAssertions.failMessage("Parser produced unexpected error reports", message, expected, reports);
            return;
        }
        ArgumentParser.ParseResult result = (ArgumentParser.ParseResult)parse.get();
        if (expected.newIndex() != result.newIndex()) {
            ParserAssertions.failMessage("Expected different index", message, expected.newIndex(), result.newIndex());
            return;
        }
        Object actual = result.result();
        if (!Objects.equals(expected.result(), actual)) {
            ParserAssertions.failMessage("Expected different result", message, expected.result(), actual);
            return;
        }
    }

    public static void assertTryParseResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, OptionalInt expected) {
        ParserAssertions.assertTryParseResult(parser, sender, label, args, 0, expected);
    }

    public static void assertTryParseResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, OptionalInt expected) {
        ParserAssertions.assertTryParseResult(parser, sender, label, args, startIndex, expected, null);
    }

    public static void assertTryParseResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, OptionalInt expected, String message) {
        ParserAssertions.assertTryParseResult(parser, new TestCommandProcessingContext(sender, label, List.of(args), startIndex), expected, message);
    }

    public static void assertTryParseResult(ArgumentParser<?> parser, CommandProcessingContext processingContext, OptionalInt expected, String message) {
        TestCommandProcessingContext context = !(processingContext instanceof TestCommandProcessingContext) ? new TestCommandProcessingContext(processingContext.sender(), processingContext.label(), processingContext.args(), processingContext.index()) : (TestCommandProcessingContext)processingContext;
        OptionalInt result = parser.tryParse(processingContext);
        if (result.isEmpty()) {
            if (expected.isEmpty()) {
                return;
            }
            List<BadCommandResponse> reports = context.getReports();
            if (reports.isEmpty()) {
                ParserAssertions.failMessage("Parser did not return a result or report any errors", message, expected, null);
                return;
            }
            ParserAssertions.failMessage("Parser failed with " + reports.size() + " report" + (reports.size() == 1 ? "" : "s"), message, expected, reports);
            return;
        }
        if (expected.isEmpty()) {
            List<BadCommandResponse> reports = context.getReports();
            if (!reports.isEmpty()) {
                ParserAssertions.failMessage("Parser produced unexpected error reports", message, expected, reports);
                return;
            }
            ParserAssertions.failMessage("Parser returned unexpected result", message, expected, result);
            return;
        }
        if (expected.getAsInt() != result.getAsInt()) {
            ParserAssertions.failMessage("Expected different result", message, expected.getAsInt(), result.getAsInt());
            return;
        }
    }

    public static void assertNotParserResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, ArgumentParser.ParseResult<?> expected) {
        ParserAssertions.assertNotParserResult(parser, sender, label, args, 0, expected);
    }

    public static void assertNotParserResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, ArgumentParser.ParseResult<?> expected) {
        ParserAssertions.assertNotParserResult(parser, sender, label, args, startIndex, expected, null);
    }

    public static void assertNotParserResult(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, ArgumentParser.ParseResult<?> expected, String message) {
        TestCommandProcessingContext context = new TestCommandProcessingContext(sender, label, List.of(args), startIndex);
        Optional parse = parser.parse((CommandProcessingContext)context);
        if (parse.isPresent()) {
            if (context.hasAnyReports()) {
                List<BadCommandResponse> reports = context.getReports();
                ParserAssertions.failMessage("Parser produced unexpected error reports", message, expected, reports);
                return;
            }
            ArgumentParser.ParseResult result = (ArgumentParser.ParseResult)parse.get();
            if (expected.newIndex() == result.newIndex() && Objects.equals(expected.result(), result.result())) {
                ParserAssertions.failMessage("Expected different result", message, expected.result(), result.result());
                return;
            }
            return;
        }
        if (context.hasAnyReports()) {
            List<BadCommandResponse> reports = context.getReports();
            ParserAssertions.failMessage("Parser unexpectedly failed with " + reports.size() + " report" + (reports.size() == 1 ? "" : "s"), message, expected, reports);
            return;
        }
    }

    public static void assertParserThrowsReport(ArgumentParser<?> parser, Sender sender, String label, String[] args, Class<? extends BadCommandResponse> expected) {
        ParserAssertions.assertParserThrowsReport(parser, sender, label, args, 0, expected);
    }

    public static void assertParserThrowsReport(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, Class<? extends BadCommandResponse> expected) {
        ParserAssertions.assertParserThrowsReport(parser, sender, label, args, startIndex, expected, null);
    }

    public static void assertParserThrowsReport(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, Class<? extends BadCommandResponse> expected, String message) {
        ParserAssertions.assertParserThrowsReport(parser, sender, label, args, startIndex, List.of(expected), message);
    }

    public static void assertParserThrowsReport(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, List<Class<? extends BadCommandResponse>> expected, String message) {
        TestCommandProcessingContext context = new TestCommandProcessingContext(sender, label, List.of(args), startIndex);
        parser.parse((CommandProcessingContext)context);
        if (!context.hasAnyReports()) {
            ParserAssertions.failMessage("Expected parser to fail but no error report has been provided", message, expected, null);
            return;
        }
        List<BadCommandResponse> reports = context.getReports();
        if (reports.size() != expected.size()) {
            ParserAssertions.failMessage("Reports aren't the same as expected", message, expected, reports);
            return;
        }
        if (CollectionHelpers.equalsList(reports.stream().map(Object::getClass).toList(), expected)) {
            return;
        }
        ParserAssertions.failMessage("Reports aren't the same as expected", message, expected, reports);
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static void assertParserTabCompletion(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, Set<String> expected, int expectedIndex) {
        ParserAssertions.assertParserTabCompletion(parser, sender, label, args, startIndex, expected, expectedIndex, null);
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static void assertParserTabCompletion(ArgumentParser<?> parser, Sender sender, String label, String[] args, int startIndex, Set<String> expected, int expectedIndex, String message) {
        TestCommandProcessingContext context = new TestCommandProcessingContext(sender, label, List.of(args), startIndex);
        Optional tabCompletionResult = parser.tabCompletion((CommandProcessingContext)context);
        if (context.hasAnyReports()) {
            List<BadCommandResponse> reports = context.getReports();
            ParserAssertions.failMessage("Parser produced unexpected error reports", message, expected, reports);
            return;
        }
        if (expected == null) {
            if (tabCompletionResult.isPresent()) {
                ParserAssertions.failMessage("Expected no tab completion", message, null, ((ArgumentParser.TabCompletionResult)tabCompletionResult.get()).result());
            }
            return;
        }
        if (tabCompletionResult.isEmpty()) {
            ParserAssertions.failMessage("Expected tab completion", message, expected, null);
            return;
        }
        Set result = ((ArgumentParser.TabCompletionResult)tabCompletionResult.get()).result();
        Assertions.assertEquals(expected, (Object)result, (String)message);
        Assertions.assertEquals((int)expectedIndex, (int)((ArgumentParser.TabCompletionResult)tabCompletionResult.get()).newIndex(), (String)message);
    }

    @ApiStatus.Internal
    private static void failMessage(String reason, String message, Object expected, Object actual) {
        AssertionFailureBuilder.assertionFailure().reason(reason).message((Object)message).expected(expected).actual(actual).buildAndThrow();
    }

    @ApiStatus.AvailableSince(value="0.0.39")
    public static String[] args(String args) {
        return args.split("\\s+");
    }
}

