/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TestCommandProcessingContext
implements CommandProcessingContext {
    private final List<BadCommandResponse> reports = new ArrayList<BadCommandResponse>();
    private final Sender sender;
    private final String label;
    private final List<String> args;
    private final int index;

    public TestCommandProcessingContext(Sender sender, String label, List<String> args, int index) {
        this.sender = sender;
        this.label = label;
        this.args = Collections.unmodifiableList(args);
        this.index = index;
    }

    public Sender sender() {
        return this.sender;
    }

    public String label() {
        return this.label;
    }

    public List<String> args() {
        return this.args;
    }

    public int index() {
        return this.index;
    }

    public RequirementResult senderMeetsRequirement(Requirement requirement) {
        return requirement.meetsRequirement(new RequirementEvaluationContext(this.sender, this.label, this.args.toArray(new String[0]), this.index));
    }

    public void report(Object source, BadCommandResponse response) {
        this.reports.add(response);
    }

    public boolean hasAnyReports() {
        return !this.reports.isEmpty();
    }

    public List<BadCommandResponse> getReports() {
        return Collections.unmodifiableList(this.reports);
    }
}

