/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import net.apartium.cocoabeans.state.AttachedWatcher;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Watcher;
import net.apartium.cocoabeans.state.WatcherOperator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public class WatcherManager
implements WatcherOperator {
    private final Set<Watcher<?>> watchers = Collections.newSetFromMap(new IdentityHashMap());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void heartbeat() {
        HashSet tempWatchers;
        this.lock.readLock().lock();
        try {
            tempWatchers = new HashSet(this.watchers);
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (Watcher watcher : tempWatchers) {
            watcher.heartbeat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> AttachedWatcher<T> watch(Observable<T> depends, final Consumer<T> consumer) {
        AttachedWatcher watcher = new AttachedWatcher<T>(depends){

            @Override
            public void onChange(T newValue) {
                consumer.accept(newValue);
            }
        };
        this.lock.writeLock().lock();
        try {
            this.watchers.add(watcher);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        watcher.attach(this);
        return watcher;
    }

    @Override
    public void detach(AttachedWatcher<?> watcher) {
        this.lock.writeLock().lock();
        try {
            this.watchers.remove(watcher);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

