/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.Objects;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;
import net.apartium.cocoabeans.structs.Entry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.41")
public class LazyWatcher<T>
implements Observer {
    private Observable<T> dependsOn;
    private T value;
    private boolean first = true;
    private boolean isDirty = true;

    private LazyWatcher(Observable<T> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public static <T> LazyWatcher<T> create(Observable<T> observable) {
        if (observable == null) {
            observable = Observable.empty();
        }
        LazyWatcher<T> dirtyWatcher = new LazyWatcher<T>(observable);
        observable.observe(dirtyWatcher);
        return dirtyWatcher;
    }

    @Override
    public void flagAsDirty(Observable<?> observable) {
        if (this.dependsOn != observable) {
            return;
        }
        this.isDirty = true;
    }

    public void setDependsOn(Observable<T> dependsOn) {
        if (this.dependsOn == dependsOn) {
            return;
        }
        this.dependsOn.removeObserver(this);
        this.dependsOn = dependsOn;
        this.dependsOn.observe(this);
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public T getLastValue() {
        return this.value;
    }

    public Entry<T, Boolean> getOrUpdate() {
        if (!this.isDirty) {
            return new Entry(this.value, (Object)false);
        }
        T newValue = this.dependsOn.get();
        if (Objects.equals(this.value, newValue) && !this.first) {
            return new Entry(this.value, (Object)false);
        }
        this.value = newValue;
        this.first = false;
        this.isDirty = false;
        return new Entry(this.value, (Object)true);
    }

    public void delete() {
        this.dependsOn.removeObserver(this);
        this.value = null;
    }

    public Observable<T> getWatchedObservable() {
        return this.dependsOn;
    }
}

