/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.apartium.cocoabeans.state.AttachedWatcher;
import net.apartium.cocoabeans.state.CompoundRecords;
import net.apartium.cocoabeans.state.ImmutableObservable;
import net.apartium.cocoabeans.state.ListObservable;
import net.apartium.cocoabeans.state.ListObservableImpl;
import net.apartium.cocoabeans.state.MappedObservable;
import net.apartium.cocoabeans.state.MutableObservable;
import net.apartium.cocoabeans.state.MutableObservableImpl;
import net.apartium.cocoabeans.state.ObservableCompound;
import net.apartium.cocoabeans.state.Observer;
import net.apartium.cocoabeans.state.SetObservable;
import net.apartium.cocoabeans.state.SetObservableImpl;
import net.apartium.cocoabeans.state.WatcherManager;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.39")
public interface Observable<T> {
    public static <T> Observable<T> empty() {
        return ImmutableObservable.EMPTY_OBSERVABLE;
    }

    public static <T> Observable<T> immutable(T value) {
        return new ImmutableObservable<T>(value);
    }

    public static <T> MutableObservable<T> mutable(T value) {
        return new MutableObservableImpl<T>(value);
    }

    public static <E> ListObservable<E> list() {
        return new ListObservableImpl();
    }

    public static <E> ListObservable<E> list(List<E> list) {
        return new ListObservableImpl<E>(list);
    }

    public static <E> SetObservable<E> set() {
        return new SetObservableImpl();
    }

    public static <E> SetObservable<E> set(Set<E> set) {
        return new SetObservableImpl<E>(set);
    }

    public static <T> Observable<T> compound(Function<List<?>, T> function, List<Observable<?>> depends) {
        return new ObservableCompound<T>(function, depends);
    }

    public static <ARG0> Observable<CompoundRecords.RecordOf1<ARG0>> compound(Observable<ARG0> arg0) {
        return CompoundRecords.compound(arg0);
    }

    public static <ARG0, ARG1> Observable<CompoundRecords.RecordOf2<ARG0, ARG1>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1) {
        return CompoundRecords.compound(arg0, arg1);
    }

    public static <ARG0, ARG1, ARG2> Observable<CompoundRecords.RecordOf3<ARG0, ARG1, ARG2>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1, Observable<ARG2> arg2) {
        return CompoundRecords.compound(arg0, arg1, arg2);
    }

    public static <ARG0, ARG1, ARG2, ARG3> Observable<CompoundRecords.RecordOf4<ARG0, ARG1, ARG2, ARG3>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1, Observable<ARG2> arg2, Observable<ARG3> arg3) {
        return CompoundRecords.compound(arg0, arg1, arg2, arg3);
    }

    public static <ARG0, ARG1, ARG2, ARG3, ARG4> Observable<CompoundRecords.RecordOf5<ARG0, ARG1, ARG2, ARG3, ARG4>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1, Observable<ARG2> arg2, Observable<ARG3> arg3, Observable<ARG4> arg4) {
        return CompoundRecords.compound(arg0, arg1, arg2, arg3, arg4);
    }

    public static <ARG0, ARG1, ARG2, ARG3, ARG4, ARG5> Observable<CompoundRecords.RecordOf6<ARG0, ARG1, ARG2, ARG3, ARG4, ARG5>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1, Observable<ARG2> arg2, Observable<ARG3> arg3, Observable<ARG4> arg4, Observable<ARG5> arg5) {
        return CompoundRecords.compound(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public static <ARG0, ARG1, ARG2, ARG3, ARG4, ARG5, ARG6> Observable<CompoundRecords.RecordOf7<ARG0, ARG1, ARG2, ARG3, ARG4, ARG5, ARG6>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1, Observable<ARG2> arg2, Observable<ARG3> arg3, Observable<ARG4> arg4, Observable<ARG5> arg5, Observable<ARG6> arg6) {
        return CompoundRecords.compound(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static <ARG0, ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7> Observable<CompoundRecords.RecordOf8<ARG0, ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1, Observable<ARG2> arg2, Observable<ARG3> arg3, Observable<ARG4> arg4, Observable<ARG5> arg5, Observable<ARG6> arg6, Observable<ARG7> arg7) {
        return CompoundRecords.compound(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public static <ARG0, ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7, ARG8> Observable<CompoundRecords.RecordOf9<ARG0, ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7, ARG8>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1, Observable<ARG2> arg2, Observable<ARG3> arg3, Observable<ARG4> arg4, Observable<ARG5> arg5, Observable<ARG6> arg6, Observable<ARG7> arg7, Observable<ARG8> arg8) {
        return CompoundRecords.compound(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public static <ARG0, ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7, ARG8, ARG9> Observable<CompoundRecords.RecordOf10<ARG0, ARG1, ARG2, ARG3, ARG4, ARG5, ARG6, ARG7, ARG8, ARG9>> compound(Observable<ARG0> arg0, Observable<ARG1> arg1, Observable<ARG2> arg2, Observable<ARG3> arg3, Observable<ARG4> arg4, Observable<ARG5> arg5, Observable<ARG6> arg6, Observable<ARG7> arg7, Observable<ARG8> arg8, Observable<ARG9> arg9) {
        return CompoundRecords.compound(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public T get();

    public void observe(Observer var1);

    public boolean removeObserver(Observer var1);

    default public <M> Observable<M> map(Function<T, M> mapper) {
        MappedObservable<T, M> observable = new MappedObservable<T, M>(this, mapper);
        this.observe(observable);
        return observable;
    }

    default public AttachedWatcher<T> watch(WatcherManager watcherManager, Consumer<T> consumer) {
        return watcherManager.watch(this, consumer);
    }
}

