/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.apartium.cocoabeans.state.CollectionObservable;
import net.apartium.cocoabeans.state.MutableObservable;
import net.apartium.cocoabeans.state.Observable;
import net.apartium.cocoabeans.state.Observer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract class AbstractCollectionObservable<E, C extends Collection<E>>
implements CollectionObservable<E, C> {
    protected final C collection;
    private final Set<Observer> observers = Collections.newSetFromMap(new WeakHashMap());
    private final MutableObservable<Integer> size;

    protected AbstractCollectionObservable(C collection) {
        this.collection = collection;
        this.size = Observable.mutable(collection.size());
    }

    @Override
    public boolean add(E element) {
        boolean result = this.collection.add(element);
        if (!result) {
            return false;
        }
        this.notifyObservers();
        return true;
    }

    @Override
    public boolean remove(E element) {
        boolean result = this.collection.remove(element);
        if (!result) {
            return false;
        }
        this.notifyObservers();
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean result = this.collection.addAll(collection);
        if (!result) {
            return false;
        }
        this.notifyObservers();
        return true;
    }

    @Override
    public boolean removeAll(Collection<? extends E> collection) {
        boolean result = this.collection.removeAll(collection);
        if (!result) {
            return false;
        }
        this.notifyObservers();
        return true;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        boolean result = this.collection.removeIf(filter);
        if (!result) {
            return false;
        }
        this.notifyObservers();
        return true;
    }

    @Override
    public boolean retainAll(Collection<? extends E> collection) {
        boolean result = this.collection.retainAll(collection);
        if (!result) {
            return false;
        }
        this.notifyObservers();
        return true;
    }

    @Override
    public void clear() {
        boolean empty = this.collection.isEmpty();
        this.collection.clear();
        if (empty) {
            return;
        }
        this.notifyObservers();
    }

    @Override
    public void observe(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public boolean removeObserver(Observer observer) {
        return this.observers.remove(observer);
    }

    protected void notifyObservers() {
        for (Observer observer : this.observers) {
            observer.flagAsDirty(this);
        }
        this.size.set(this.collection.size());
    }

    @Override
    public Observable<Integer> size() {
        return this.size;
    }
}

