/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.visibility;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.apartium.cocoabeans.spigot.visibility.VisibilityManager;
import net.apartium.cocoabeans.spigot.visibility.VisibilityPlayer;
import org.bukkit.entity.Player;

public class VisibilityGroup {
    private final VisibilityManager manager;
    private final String name;
    private final Set<VisibilityPlayer> players;
    private final Set<VisibilityGroup> visibleGroups;
    private final Set<VisibilityGroup> hiddenGroups;

    VisibilityGroup(VisibilityManager manager, String name) {
        this.manager = manager;
        this.name = name;
        this.players = new HashSet<VisibilityPlayer>();
        this.visibleGroups = Collections.newSetFromMap(new WeakHashMap());
        this.hiddenGroups = Collections.newSetFromMap(new WeakHashMap());
    }

    public boolean addPlayer(Player player) {
        return this.addPlayer(this.manager.getPlayer(player));
    }

    public boolean addPlayer(UUID uuid) {
        return this.addPlayer(this.manager.getPlayer(uuid));
    }

    public boolean addPlayer(VisibilityPlayer player) {
        if (!this.players.add(player)) {
            return false;
        }
        boolean empty = player.getVisibleGroups().isEmpty();
        player.addVisibleGroup(this);
        Player bukkitPlayer = player.getPlayer().orElse(null);
        if (empty && bukkitPlayer != null) {
            this.manager.handlePlayerJoin(bukkitPlayer);
        } else if (bukkitPlayer != null) {
            HashSet<VisibilityPlayer> visited = new HashSet<VisibilityPlayer>();
            for (VisibilityGroup visibilityGroup : player.getVisibleGroups()) {
                for (VisibilityPlayer visibilityPlayer : visibilityGroup.getPlayers()) {
                    Optional<Player> target;
                    if (!visited.add(visibilityPlayer) || (target = visibilityPlayer.getPlayer()).isEmpty()) continue;
                    this.manager.updateVisiblityForPlayer(target.get());
                }
            }
        }
        return true;
    }

    public boolean removePlayer(Player player) {
        return this.removePlayer(this.manager.getPlayer(player));
    }

    public boolean removePlayer(VisibilityPlayer player) {
        if (!this.players.remove(player)) {
            return false;
        }
        player.removeVisibleGroup(this);
        if (player.getPlayer().isEmpty()) {
            return true;
        }
        HashSet<VisibilityPlayer> visited = new HashSet<VisibilityPlayer>();
        visited.add(player);
        this.manager.updateVisiblityForPlayer(player.getPlayer().get());
        for (VisibilityPlayer visibilityPlayer : this.getPlayers()) {
            Optional<Player> target;
            if (!visited.add(visibilityPlayer) || (target = visibilityPlayer.getPlayer()).isEmpty()) continue;
            this.manager.updateVisiblityForPlayer(target.get());
        }
        for (VisibilityGroup visibilityGroup : player.getVisibleGroups()) {
            for (VisibilityPlayer visibilityPlayer : visibilityGroup.getPlayers()) {
                Optional<Player> target;
                if (!visited.add(visibilityPlayer) || (target = visibilityPlayer.getPlayer()).isEmpty()) continue;
                this.manager.updateVisiblityForPlayer(target.get());
            }
        }
        return true;
    }

    public boolean addVisibleGroup(VisibilityGroup group) {
        return this.addGroup(group, true);
    }

    public boolean addHiddenGroup(VisibilityGroup group) {
        return this.addGroup(group, false);
    }

    private boolean addGroup(VisibilityGroup group, boolean visible) {
        if (group == this) {
            return false;
        }
        boolean result = visible ? this.visibleGroups.add(group) : this.hiddenGroups.add(group);
        if (!result) {
            return false;
        }
        for (VisibilityPlayer visibilityPlayer : this.players) {
            Optional<Player> target = visibilityPlayer.getPlayer();
            if (target.isEmpty()) continue;
            this.manager.updateVisiblityForPlayer(target.get());
        }
        return true;
    }

    public boolean removeVisibleGroup(VisibilityGroup group) {
        if (!this.visibleGroups.remove(group)) {
            return false;
        }
        for (VisibilityPlayer visibilityPlayer : this.players) {
            Optional<Player> target = visibilityPlayer.getPlayer();
            if (target.isEmpty()) continue;
            this.manager.updateVisiblityForPlayer(target.get());
        }
        return true;
    }

    public boolean removeHiddenGroup(VisibilityGroup group) {
        if (!this.hiddenGroups.remove(group)) {
            return false;
        }
        for (VisibilityPlayer visibilityPlayer : this.players) {
            Optional<Player> target = visibilityPlayer.getPlayer();
            if (target.isEmpty()) continue;
            this.manager.updateVisiblityForPlayer(target.get());
        }
        return true;
    }

    public Collection<VisibilityPlayer> getPlayers() {
        return Collections.unmodifiableCollection(this.players);
    }

    public String getName() {
        return this.name;
    }

    public Collection<VisibilityGroup> getVisibleGroups() {
        return Collections.unmodifiableCollection(this.visibleGroups);
    }

    public Collection<VisibilityGroup> getHiddenGroups() {
        return Collections.unmodifiableCollection(this.hiddenGroups);
    }

    public boolean hasPlayer(Player player) {
        return this.players.contains(this.manager.getPlayer(player));
    }
}

