/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.lazies;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.apartium.cocoabeans.Dispensers;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ListenerAutoRegistration {
    private final JavaPlugin plugin;
    private final boolean loadDevListeners;
    private final List<Object> injectableObjects;

    public ListenerAutoRegistration(JavaPlugin plugin, boolean loadDevListeners) {
        this.plugin = plugin;
        this.loadDevListeners = loadDevListeners;
        this.injectableObjects = new ArrayList<Object>();
        this.injectableObjects.add(plugin);
    }

    public void addInjectableObject(Object injectableObject) {
        this.injectableObjects.add(injectableObject);
    }

    public void register(String packageName) {
        this.register(packageName, true);
    }

    public void register(String packageName, boolean deep) {
        this.register(packageName, deep, Set.of());
    }

    public void register(String packageName, boolean deep, Set<Class<?>> ignore) {
        ClassPath classPath;
        ClassLoader classLoader = this.plugin.getClass().getClassLoader();
        try {
            classPath = ClassPath.from((ClassLoader)classLoader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (ClassPath.ClassInfo classInfo : deep ? classPath.getTopLevelClassesRecursive(packageName) : classPath.getTopLevelClasses(packageName)) {
            try {
                boolean devListener;
                Class<?> clazz = classLoader.loadClass(classInfo.getName());
                if (!Listener.class.isAssignableFrom(clazz) || ignore.contains(clazz) || (devListener = clazz.isAnnotationPresent(DevServerListener.class)) && !this.loadDevListeners) continue;
                Constructor<?> constructor = clazz.getConstructors()[0];
                Listener instance = this.createInstance(constructor, this.injectableObjects);
                if (instance == null) {
                    this.plugin.getLogger().warning("Failed to create listener " + clazz.getSimpleName() + "!");
                    continue;
                }
                Bukkit.getPluginManager().registerEvents(instance, (Plugin)this.plugin);
                this.plugin.getLogger().info("Loaded " + (devListener ? "dev " : "") + "listener " + clazz.getSimpleName() + "!");
            }
            catch (Exception e) {
                Dispensers.dispense((Throwable)e);
            }
        }
    }

    private Listener createInstance(Constructor<?> constructor, List<Object> injectableObjects) {
        Object[] objects = new Object[constructor.getParameterCount()];
        for (int i = 0; i < constructor.getParameterCount(); ++i) {
            Class<?> target = constructor.getParameterTypes()[i];
            Object value = null;
            for (Object o : injectableObjects) {
                if (!target.isInstance(o)) continue;
                value = o;
                break;
            }
            if (value == null) {
                this.plugin.getLogger().warning("No injectable object found for " + target.getName() + "!");
                return null;
            }
            objects[i] = value;
        }
        try {
            return (Listener)constructor.newInstance(objects);
        }
        catch (Exception e) {
            Dispensers.dispense((Throwable)e);
            return null;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DevServerListener {
    }
}

