/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot;

import net.apartium.cocoabeans.spigot.ServerUtils;
import net.apartium.cocoabeans.spigot.inventory.ItemFactory;
import net.apartium.cocoabeans.spigot.inventory.ItemUtilsHelpers;
import net.apartium.cocoabeans.spigot.visibility.PlayerVisibilityController;
import net.apartium.cocoabeans.structs.MinecraftVersion;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VersionedImplInstantiator {
    public static ItemUtilsHelpers createItemUtilsHelpers() {
        MinecraftVersion minecraftVersion = ServerUtils.getVersion();
        return switch (minecraftVersion.update()) {
            case 8 -> VersionedImplInstantiator.createItemUtilsHelper("inventory.ItemUtilsHelpers_1_8_R1");
            default -> VersionedImplInstantiator.createItemUtilsHelper("inventory.ItemUtilsHelpers_1_20_R1");
        };
    }

    public static ItemFactory createItemFactory() {
        MinecraftVersion minecraftVersion = ServerUtils.getVersion();
        return switch (minecraftVersion.update()) {
            case 8 -> VersionedImplInstantiator.constructItemFactory("inventory.ItemFactory_1_8_R1");
            default -> VersionedImplInstantiator.constructItemFactory("inventory.ItemFactory_1_20_R1");
        };
    }

    public static Enchantment createGlow() {
        MinecraftVersion minecraftVersion = ServerUtils.getVersion();
        return switch (minecraftVersion.update()) {
            case 8 -> VersionedImplInstantiator.constructEnchantGlow("inventory.EnchantGlow_1_8_R1");
            default -> VersionedImplInstantiator.constructEnchantGlow("inventory.EnchantGlow_1_20_R1");
        };
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public static PlayerVisibilityController createPlayerVisibilityController() {
        MinecraftVersion minecraftVersion = ServerUtils.getVersion();
        return switch (minecraftVersion.update()) {
            case 8 -> VersionedImplInstantiator.constructPlayerVisibilityController("visibility.PlayerVisibilityController_1_8_R1");
            default -> VersionedImplInstantiator.constructPlayerVisibilityController("visibility.PlayerVisibilityController_1_20_R1");
        };
    }

    private static ItemFactory constructItemFactory(String clazz) {
        return VersionedImplInstantiator.construct(clazz, ItemFactory.class);
    }

    private static Enchantment constructEnchantGlow(String clazz) {
        return VersionedImplInstantiator.construct(clazz, Enchantment.class);
    }

    private static ItemUtilsHelpers createItemUtilsHelper(String clazz) {
        return VersionedImplInstantiator.construct(clazz, ItemUtilsHelpers.class);
    }

    private static PlayerVisibilityController constructPlayerVisibilityController(String clazz) {
        return VersionedImplInstantiator.construct(clazz, PlayerVisibilityController.class);
    }

    public static <T> T construct(String name, Class<T> type) {
        try {
            Class<T> cls = Class.forName(String.format("net.apartium.cocoabeans.spigot.%s", name), true, ItemFactory.class.getClassLoader()).asSubclass(type);
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

