/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot;

import net.apartium.cocoabeans.Ensures;
import net.apartium.cocoabeans.spigot.ServerInfoStore;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.40")
public class NMSUtils {
    private static final String NMS_PATH = "net.minecraft.server";
    private static final String OBC_PATH = "org.bukkit.craftbukkit";

    private NMSUtils() {
    }

    public static String formatNMS(String path) {
        Ensures.isFalse((path == null || path.trim().isEmpty() ? 1 : 0) != 0, (RuntimeException)new IllegalArgumentException("Path cannot be null or empty"));
        if (ServerInfoStore.getInstance().containsVersion()) {
            String[] split = path.split("\\.");
            String className = split[split.length - 1];
            String serverVersion = ServerInfoStore.getInstance().getServerVersion();
            return String.format("%s.%s.%s", NMS_PATH, serverVersion, className);
        }
        return path.startsWith(NMS_PATH) ? path : String.format("%s.%s", NMS_PATH, path);
    }

    public static String formatOBC(String path) {
        Ensures.isFalse((path == null || path.trim().isEmpty() ? 1 : 0) != 0, (RuntimeException)new IllegalArgumentException("Path cannot be null or empty"));
        Ensures.isFalse((boolean)path.equals(OBC_PATH), (RuntimeException)new IllegalArgumentException("Not enough information to format path"));
        if (path.startsWith(OBC_PATH)) {
            path = path.substring(OBC_PATH.length() + 1);
        }
        return String.format("%s.%s", ServerInfoStore.getInstance().getOBCPackageName(), path);
    }
}

