/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.visibility;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.apartium.cocoabeans.spigot.visibility.VisibilityGroup;
import net.apartium.cocoabeans.spigot.visibility.VisibilityManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class VisibilityPlayer {
    private final VisibilityManager manager;
    private final UUID uuid;
    private WeakReference<Player> playerRef;
    private final Set<VisibilityGroup> visibleGroups;

    VisibilityPlayer(VisibilityManager manager, UUID uuid) {
        this.manager = manager;
        this.uuid = uuid;
        this.playerRef = new WeakReference<Player>(Bukkit.getPlayer((UUID)uuid));
        this.visibleGroups = Collections.newSetFromMap(new WeakHashMap());
    }

    VisibilityPlayer(VisibilityManager manager, Player player) {
        this.manager = manager;
        this.uuid = player.getUniqueId();
        this.playerRef = new WeakReference<Player>(player);
        this.visibleGroups = Collections.newSetFromMap(new WeakHashMap());
    }

    public VisibilityManager getManager() {
        return this.manager;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public Optional<Player> getPlayer() {
        Player player = (Player)this.playerRef.get();
        if (player != null) {
            return Optional.of(player);
        }
        player = Bukkit.getPlayer((UUID)this.uuid);
        if (player == null) {
            return Optional.empty();
        }
        this.playerRef = new WeakReference<Player>(player);
        return Optional.of(player);
    }

    public Collection<VisibilityGroup> getVisibleGroups() {
        return Collections.unmodifiableCollection(this.visibleGroups);
    }

    void addVisibleGroup(VisibilityGroup group) {
        this.visibleGroups.add(group);
    }

    void removeVisibleGroup(VisibilityGroup group) {
        this.visibleGroups.remove(group);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisibilityPlayer that = (VisibilityPlayer)o;
        return Objects.equals(this.manager, that.manager) && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.manager, this.uuid);
    }
}

