/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.apartium.cocoabeans.structs.MinecraftVersion;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ServerUtils {
    public static final String VERSION_PATTERN = "\\d+(\\.\\d+)*";
    private static final MinecraftVersion version = ServerUtils.detectVersion();

    @NotNull
    public static MinecraftVersion getVersion() {
        return version;
    }

    @ApiStatus.Internal
    private static MinecraftVersion detectVersion() {
        String version = ServerUtils.extractVersionNumber(Bukkit.getBukkitVersion());
        if (version == null) {
            return MinecraftVersion.UNKNOWN;
        }
        String[] split = version.split("\\.");
        try {
            return MinecraftVersion.getVersion((int)Integer.parseInt(split[0]), (int)Integer.parseInt(split[1]), (int)(split.length == 2 ? 0 : Integer.parseInt(split[2])), ServerUtils::getProtocolVersion);
        }
        catch (NumberFormatException e) {
            Bukkit.getLogger().log(Level.SEVERE, "An error occurred while parsing version string: " + version, e);
            return MinecraftVersion.UNKNOWN;
        }
    }

    @ApiStatus.Internal
    private static int getProtocolVersion() {
        try {
            Class<?> constants = Class.forName("net.minecraft.SharedConstants");
            return (Integer)constants.getMethod("getProtocolVersion", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Bukkit.getLogger().log(Level.SEVERE, "An error occurred while trying to get protocol version (defaulting to -1)", e);
            return -1;
        }
    }

    private static String extractVersionNumber(String versionString) {
        Matcher matcher = Pattern.compile(VERSION_PATTERN).matcher(versionString);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }
}

