/*
 * Decompiled with CFR 0.152.
 */
package net.anzix.aws.maven;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.resource.Resource;

class TransferListenerSupport {
    private Wagon wagon;
    private Set<TransferListener> listeners = new HashSet<TransferListener>();

    public TransferListenerSupport(Wagon wagon) {
        this.wagon = wagon;
    }

    public void addListener(TransferListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TransferListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasListener(TransferListener listener) {
        return this.listeners.contains(listener);
    }

    public void fireTransferInitiated(Resource resource, int requestType) {
        TransferEvent event = new TransferEvent(this.wagon, resource, 0, requestType);
        for (TransferListener listener : this.listeners) {
            listener.transferInitiated(event);
        }
    }

    public void fireTransferStarted(Resource resource, int requestType) {
        TransferEvent event = new TransferEvent(this.wagon, resource, 1, requestType);
        for (TransferListener listener : this.listeners) {
            listener.transferStarted(event);
        }
    }

    public void fireTransferProgress(Resource resource, int requestType, byte[] buffer, int length) {
        TransferEvent event = new TransferEvent(this.wagon, resource, 3, requestType);
        for (TransferListener listener : this.listeners) {
            listener.transferProgress(event, buffer, length);
        }
    }

    public void fireTransferCompleted(Resource resource, int requestType) {
        TransferEvent event = new TransferEvent(this.wagon, resource, 2, requestType);
        for (TransferListener listener : this.listeners) {
            listener.transferCompleted(event);
        }
    }

    public void fireTransferError(Resource resource, int requestType, Exception e) {
        TransferEvent event = new TransferEvent(this.wagon, resource, e, requestType);
        for (TransferListener listener : this.listeners) {
            listener.transferError(event);
        }
    }
}

