/*
 * Decompiled with CFR 0.152.
 */
package net.anzix.aws.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.anzix.aws.maven.TransferProgress;

public class TransferProgressFileInputStream
extends FileInputStream {
    private TransferProgress progress;

    public TransferProgressFileInputStream(File file, TransferProgress progress) throws FileNotFoundException {
        super(file);
        this.progress = progress;
    }

    public int read() throws IOException {
        int b = super.read();
        this.progress.notify(new byte[]{(byte)b}, 1);
        return b;
    }

    public int read(byte[] b) throws IOException {
        int count = super.read(b);
        this.progress.notify(b, b.length);
        return count;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        if (off == 0) {
            this.progress.notify(b, len);
        } else {
            byte[] bytes = new byte[len];
            System.arraycopy(b, off, bytes, 0, len);
            this.progress.notify(bytes, len);
        }
        return count;
    }
}

