/*
 * Decompiled with CFR 0.152.
 */
package net.anzix.aws.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.anzix.aws.maven.AbstractWagon;
import net.anzix.aws.maven.TransferProgress;
import net.anzix.aws.maven.TransferProgressFileOutputStream;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.GSCredentials;
import org.jets3t.service.security.ProviderCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStorageServiceWagon
extends AbstractWagon {
    private String AMAZON_URL = "s3.amazonaws.com";
    private String GOOGLE_URL = "commondatastorage.googleapis.com";
    private RestStorageService service;
    private String bucket;
    private String basedir;

    public SimpleStorageServiceWagon() {
        super(false);
    }

    @Override
    protected void connectToRepository(Repository source, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws AuthenticationException {
        block6: {
            try {
                String provider = null;
                this.bucket = source.getUsername();
                if (this.bucket == null || "".equals(this.bucket)) {
                    this.bucket = source.getHost();
                    provider = this.AMAZON_URL;
                } else {
                    provider = source.getHost();
                }
                Credentials c = this.getCredentials(authenticationInfo);
                if (this.AMAZON_URL.equals(provider)) {
                    this.service = new RestS3Service((ProviderCredentials)new AWSCredentials(c.access, c.secret));
                    break block6;
                }
                if (this.GOOGLE_URL.equals(provider)) {
                    this.service = new GoogleStorageService((ProviderCredentials)new GSCredentials(c.access, c.secret));
                    break block6;
                }
                throw new IllegalArgumentException("Private Clouds not supported yet. Use s3://bucketname@" + this.AMAZON_URL + " or s3://bucketname@" + this.GOOGLE_URL);
            }
            catch (ServiceException e) {
                throw new AuthenticationException("Cannot authenticate with current credentials", (Throwable)e);
            }
        }
        this.basedir = this.getBaseDir(source);
    }

    @Override
    protected boolean doesRemoteResourceExist(String resourceName) {
        try {
            this.service.getObjectDetails(this.bucket, this.basedir + resourceName);
        }
        catch (ServiceException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void disconnectFromRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getResource(String resourceName, File destination, TransferProgress progress) throws ResourceDoesNotExistException, ServiceException, IOException {
        StorageObject object;
        try {
            object = this.service.getObject(this.bucket, this.basedir + resourceName);
        }
        catch (ServiceException e) {
            throw new ResourceDoesNotExistException("Resource " + resourceName + " does not exist in the repository", (Throwable)e);
        }
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        InputStream in = null;
        TransferProgressFileOutputStream out = null;
        try {
            int length;
            in = object.getDataInputStream();
            out = new TransferProgressFileOutputStream(destination, progress);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    protected boolean isRemoteResourceNewer(String resourceName, long timestamp) throws ServiceException {
        StorageObject object = this.service.getObjectDetails(this.bucket, this.basedir + resourceName);
        return object.getLastModifiedDate().compareTo(new Date(timestamp)) < 0;
    }

    @Override
    protected List<String> listDirectory(String directory) throws Exception {
        StorageObject[] objects = this.service.listObjects(this.bucket, this.basedir + directory, "");
        ArrayList<String> fileNames = new ArrayList<String>(objects.length);
        for (StorageObject object : objects) {
            fileNames.add(object.getKey());
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putResource(File source, String destination, TransferProgress progress) throws ServiceException, IOException {
        this.buildDestinationPath(this.getDestinationPath(destination));
        StorageObject object = new StorageObject(this.basedir + destination);
        object.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        object.setDataInputFile(source);
        object.setContentLength(source.length());
        InputStream in = null;
        try {
            int length;
            this.service.putObject(this.bucket, object);
            in = new FileInputStream(source);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                progress.notify(buffer, length);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void buildDestinationPath(String destination) throws ServiceException {
        StorageObject object = new StorageObject(this.basedir + destination + "/");
        object.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        object.setContentLength(0L);
        this.service.putObject(this.bucket, object);
        int index = destination.lastIndexOf(47);
        if (index != -1) {
            this.buildDestinationPath(destination.substring(0, index));
        }
    }

    private String getDestinationPath(String destination) {
        return destination.substring(0, destination.lastIndexOf(47));
    }

    private String getBaseDir(Repository source) {
        StringBuilder sb = new StringBuilder(source.getBasedir());
        sb.deleteCharAt(0);
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    private Credentials getCredentials(AuthenticationInfo authenticationInfo) throws AuthenticationException {
        if (authenticationInfo == null) {
            String example = "<server>\n   <id>repo_key</id>\n   <username>access_key</username>\n   <password>secret_key</password>\n</server>";
            throw new AuthenticationException("Missing authentication info. Add a \n" + example + "\n to your settings.xml!");
        }
        String accessKey = authenticationInfo.getUserName();
        String secretKey = authenticationInfo.getPassphrase();
        if ("".equals(secretKey)) {
            throw new AuthenticationException("With maven3 you should encrypt the secretKey (see http://maven.apache.org/guides/mini/guide-encryption.html) or use the password field.");
        }
        if (secretKey == null) {
            secretKey = authenticationInfo.getPassword();
        }
        if (accessKey == null || secretKey == null) {
            throw new AuthenticationException("S3 requires a username and passphrase to be set.");
        }
        return new Credentials(accessKey, secretKey);
    }

    private class Credentials {
        public String access;
        public String secret;

        public Credentials(String access, String secret) {
            this.access = access;
            this.secret = secret;
        }
    }
}

