/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.graphml.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.anwiba.tools.graphml.utilities.Graph;
import net.anwiba.tools.graphml.utilities.Node;

public class GraphUtilities {
    public static Map<String, List<String>> normalize(Map<String, List<String>> graphMap) {
        Graph<String> graph = GraphUtilities.convert(graphMap);
        GraphUtilities.normalize(graph);
        return GraphUtilities.convert(graph);
    }

    public static void normalize(Graph<String> graph) {
        for (Node<String> node : graph.nodes()) {
            Iterable<Node<String>> children = GraphUtilities.copy(node.children());
            for (Node<String> child : children) {
                if (!node.childrenContains(child)) continue;
                node.remove(child);
            }
        }
        graph.reset();
    }

    public static Graph<String> add(Graph<String> graph, Graph<String> other) {
        HashSet<Node<String>> nodes = new HashSet<Node<String>>();
        Graph<String> result = new Graph<String>();
        for (Node<String> node : graph.nodes()) {
            nodes.add(node);
            result.add(new Node<String>(node.getObject()));
        }
        for (Node<String> node : other.nodes()) {
            nodes.add(node);
            result.add(new Node<String>(node.getObject()));
        }
        for (Node<String> node : nodes) {
            Node<String> clone = result.get(node.getObject());
            for (Node<String> child : node.children()) {
                if (!nodes.contains(child)) continue;
                clone.add(result.get(child.getObject()));
            }
        }
        return result;
    }

    public static Graph<String> intersect(Graph<String> graph, Graph<String> other) {
        HashSet<Node<String>> nodes = new HashSet<Node<String>>();
        Graph<String> result = new Graph<String>();
        for (Node<String> node : graph.nodes()) {
            if (!other.contains(node)) continue;
            nodes.add(node);
            result.add(new Node<String>(node.getObject()));
        }
        for (Node<String> node : nodes) {
            Node<String> clone = result.get(node.getObject());
            for (Node<String> child : node.children()) {
                if (!nodes.contains(child)) continue;
                clone.add(result.get(child.getObject()));
            }
        }
        return result;
    }

    public static Iterable<Node<String>> copy(Iterable<Node<String>> nodes) {
        ArrayList<Node<String>> copy = new ArrayList<Node<String>>();
        for (Node<String> node : nodes) {
            copy.add(node);
        }
        return copy;
    }

    public static Graph<String> convert(Map<String, List<String>> graphMap) {
        Set<String> keys = graphMap.keySet();
        Graph<String> graph = new Graph<String>();
        for (String key : keys) {
            graph.add(new Node<String>(key));
        }
        for (String key : keys) {
            Node<String> node = graph.get(key);
            List<String> children = graphMap.get(key);
            for (String child : children) {
                node.add(graph.get(child));
            }
        }
        return graph;
    }

    public static Map<String, List<String>> convert(Graph<String> graph) {
        HashMap<String, List<String>> graphMap = new HashMap<String, List<String>>();
        Iterable<Node<String>> nodes = graph.nodes();
        for (Node<String> node : nodes) {
            if (!graphMap.containsKey(node.getObject())) {
                graphMap.put(node.getObject(), new ArrayList());
            }
            List edges = (List)graphMap.get(node.getObject());
            Iterable<Node<String>> children = node.children();
            for (Node<String> child : children) {
                edges.add(child.getObject());
            }
        }
        return graphMap;
    }
}

