/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.graphml.utilities;

import java.util.HashSet;
import java.util.Set;

public class Node<T> {
    Set<Node<T>> subchildren = new HashSet<Node<T>>();
    Set<Node<T>> notContainingBySubchildren = new HashSet<Node<T>>();
    Set<Node<T>> children = new HashSet<Node<T>>();
    private final T object;

    public Node(T object) {
        this.object = object;
    }

    public void add(Node<T> childe) {
        this.children.add(childe);
    }

    public void remove(Node<T> childe) {
        this.children.remove(childe);
    }

    public Iterable<Node<T>> children() {
        return this.children;
    }

    public T getObject() {
        return this.object;
    }

    public boolean childrenContains(Node<T> node) {
        if (this.subchildren.contains(node)) {
            return true;
        }
        if (this.notContainingBySubchildren.contains(node)) {
            return false;
        }
        for (Node<T> child : this.children) {
            if (!child.contains(node)) continue;
            this.subchildren.add(node);
            return true;
        }
        this.notContainingBySubchildren.add(node);
        return false;
    }

    public boolean contains(Node<T> node) {
        if (this.children.contains(node) || this.subchildren.contains(node)) {
            return true;
        }
        if (this.notContainingBySubchildren.contains(node)) {
            return false;
        }
        for (Node<T> child : this.children) {
            if (!child.contains(node)) continue;
            this.subchildren.add(node);
            return true;
        }
        this.notContainingBySubchildren.add(node);
        return false;
    }

    public void reset() {
        this.subchildren.clear();
        this.notContainingBySubchildren.clear();
    }
}

