/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.graphml.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.anwiba.tools.simple.graphml.generated.Edge;
import net.anwiba.tools.simple.graphml.generated.Graph;
import net.anwiba.tools.simple.graphml.generated.GraphMl;
import net.anwiba.tools.simple.graphml.generated.Key;
import net.anwiba.tools.simple.graphml.generated.Node;
import net.anwiba.tools.yworks.labels.generated.ObjectFactory;

public class GraphMarkupLanguageWriter
implements Closeable {
    private final Writer writer;
    private final GraphMl root;

    public GraphMarkupLanguageWriter(Writer writer) {
        Graph graph = new Graph();
        graph.setId("G");
        graph.setEdgedefault("directed");
        this.writer = writer;
        this.root = new GraphMl();
        this.root.setGraph(graph);
    }

    public void set(Graph graph) {
        this.root.setGraph(graph);
    }

    public void add(Key key) {
        this.root.getKey().add(key);
    }

    public void add(Node node) {
        this.root.getGraph().getNode().add(node);
    }

    public void add(Edge edge) {
        this.root.getGraph().getEdge().add(edge);
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{net.anwiba.tools.simple.graphml.generated.ObjectFactory.class, net.anwiba.tools.yworks.shapenode.generated.ObjectFactory.class, ObjectFactory.class});
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)this.root, this.writer);
            }
            catch (JAXBException exception) {
                throw new IOException(exception);
            }
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }
}

