/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.Objects;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.tools.generator.java.bean.configuration.Bean;
import net.anwiba.tools.generator.java.bean.factory.AbstractSourceFactory;

public class EqualsFactory
extends AbstractSourceFactory {
    private final JCodeModel codeModel;

    public EqualsFactory(JCodeModel codeModel, IFactory<String, Class<? extends Annotation>, CreationException> annotationClassfactory) {
        super(codeModel, annotationClassfactory);
        this.codeModel = codeModel;
    }

    public void create(Bean configuration, JDefinedClass bean, Iterable<JFieldVar> fields) {
        if (!configuration.isEqualsEnabled()) {
            return;
        }
        this.createEquals(bean, fields);
        this.createHashCode(bean, fields);
    }

    private void createHashCode(JDefinedClass bean, Iterable<JFieldVar> fields) {
        JMethod method = bean.method(1, (JType)this.codeModel.INT, "hashCode");
        method.annotate(Override.class);
        JBlock block = method.body().block();
        JClass objectUtilities = this._classByNames(Objects.class.getName(), new String[0]);
        JInvocation hashCode = objectUtilities.staticInvoke("hashCode");
        for (JFieldVar field : fields) {
            hashCode = hashCode.arg((JExpression)JExpr.refthis((String)field.name()));
        }
        block._return((JExpression)hashCode);
    }

    public void createEquals(JDefinedClass bean, Iterable<JFieldVar> fields) {
        JMethod method = bean.method(1, (JType)this.codeModel.BOOLEAN, "equals");
        method.annotate(Override.class);
        JVar object = method.param(this._type(Object.class.getName(), new String[0]), "object");
        JBlock block = method.body();
        block._if(JExpr._this().eq((JExpression)object))._then()._return(JExpr.TRUE);
        block._if(object._instanceof((JType)bean).not())._then()._return(JExpr.FALSE);
        JExpression result = JExpr.TRUE;
        JVar other = block.decl((JType)bean, "other", (JExpression)JExpr.cast((JType)bean, (JExpression)object));
        JClass objectUtilities = this._classByNames(Objects.class.getName(), new String[0]);
        for (JFieldVar field : fields) {
            result = result.cand((JExpression)objectUtilities.staticInvoke("equals").arg((JExpression)JExpr.refthis((String)field.name())).arg((JExpression)other.ref((JVar)field)));
        }
        block._return(result);
    }
}

