/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import net.anwiba.commons.ensure.Conditions;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.ensure.ICondition;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.tools.generator.java.bean.JavaConstants;
import net.anwiba.tools.generator.java.bean.configuration.Parameter;
import net.anwiba.tools.generator.java.bean.configuration.Type;
import net.anwiba.tools.generator.java.bean.value.IValueTypeVisitor;

public class AbstractSourceFactory {
    private final JCodeModel codeModel;
    private final IFactory<String, Class<? extends Annotation>, CreationException> annotationClassfactory;

    public AbstractSourceFactory(JCodeModel codeModel, IFactory<String, Class<? extends Annotation>, CreationException> annotationClassfactory) {
        this.annotationClassfactory = annotationClassfactory;
        Ensure.ensureThatArgument((Object)codeModel, (ICondition)Conditions.notNull());
        this.codeModel = codeModel;
    }

    protected JCodeModel getCodeModel() {
        return this.codeModel;
    }

    protected void annotate(JAnnotatable annotatable, Iterable<net.anwiba.tools.generator.java.bean.configuration.Annotation> annotationConfigurations) throws CreationException {
        Ensure.ensureThatArgument((Object)annotatable, (ICondition)Conditions.notNull());
        Ensure.ensureThatArgument(annotationConfigurations, (ICondition)Conditions.notNull());
        for (net.anwiba.tools.generator.java.bean.configuration.Annotation annotationConfiguration : annotationConfigurations) {
            this.annotate(annotatable, annotationConfiguration);
        }
    }

    protected void addTo(JDocComment javadoc, String comment) {
        if (comment == null || comment.isBlank()) {
            return;
        }
        javadoc.add((Object)comment);
    }

    Class<? extends Annotation> getAnnotationClass(String name) throws CreationException {
        return (Class)this.annotationClassfactory.create((Object)name);
    }

    protected void annotate(JAnnotatable annotatable, net.anwiba.tools.generator.java.bean.configuration.Annotation annotation) throws CreationException {
        Ensure.ensureThatArgument((Object)annotatable, (ICondition)Conditions.notNull());
        Ensure.ensureThatArgument((Object)annotation, (ICondition)Conditions.notNull());
        JAnnotationUse annotate = annotatable.annotate(this._classByNames(annotation.name(), new String[0]));
        this.parameter(annotate, annotation);
    }

    private void parameter(final JAnnotationUse annotate, net.anwiba.tools.generator.java.bean.configuration.Annotation annotation) throws CreationException {
        Iterable<Parameter> parameters = annotation.parameters();
        for (final Parameter parameter : parameters) {
            for (final Object value : parameter.values()) {
                parameter.type().accept(new IValueTypeVisitor(){

                    @Override
                    public void annotations() throws CreationException {
                        List chAnnotations = (List)value;
                        JAnnotationArrayMember paramArray = annotate.paramArray(parameter.name());
                        for (net.anwiba.tools.generator.java.bean.configuration.Annotation parameter2 : chAnnotations) {
                            AbstractSourceFactory.this.parameter(paramArray.annotate(AbstractSourceFactory.this.getAnnotationClass(parameter2.name())), parameter2);
                        }
                    }

                    @Override
                    public void annotation() throws CreationException {
                        net.anwiba.tools.generator.java.bean.configuration.Annotation chAnnotation = (net.anwiba.tools.generator.java.bean.configuration.Annotation)value;
                        AbstractSourceFactory.this.parameter(annotate.annotationParam(parameter.name(), AbstractSourceFactory.this.getAnnotationClass(chAnnotation.name())), chAnnotation);
                    }

                    @Override
                    public void enumartation() {
                        annotate.param(parameter.name(), (Enum)value);
                    }

                    @Override
                    public void string() {
                        annotate.param(parameter.name(), (String)String.class.cast(value));
                    }

                    @Override
                    public void integer() {
                        annotate.param(parameter.name(), ((Integer)Integer.class.cast(value)).intValue());
                    }

                    @Override
                    public void clazz() {
                        if (value instanceof String) {
                            annotate.param(parameter.name(), (JType)AbstractSourceFactory.this._class((String)value, new JClass[0]));
                            return;
                        }
                        annotate.param(parameter.name(), (Class)Class.class.cast(value));
                    }

                    @Override
                    public void logical() {
                        annotate.param(parameter.name(), ((Boolean)Boolean.class.cast(value)).booleanValue());
                    }
                });
            }
        }
    }

    protected JDefinedClass _class(String name, ClassType clazz) throws JClassAlreadyExistsException {
        Ensure.ensureThatArgument((Object)name, (ICondition)Conditions.notNull());
        Ensure.ensureThatArgument((Object)clazz, (ICondition)Conditions.notNull());
        return this.codeModel._class(name, ClassType.CLASS);
    }

    protected JType _class(Type configuration, boolean isPrimitivesEnabled) {
        if (!isPrimitivesEnabled && JavaConstants.primitives.contains(configuration.name()) && configuration.dimension() == 0) {
            JType _class = this._type(JavaConstants.primitiveClasses.get(configuration.name()), new String[0]);
            for (int i = 0; i < configuration.dimension(); ++i) {
                _class = _class.array();
            }
            return _class;
        }
        JType _class = this._type(configuration.name(), configuration.generics());
        for (int i = 0; i < configuration.dimension(); ++i) {
            _class = _class.array();
        }
        return _class;
    }

    protected JClass _classByNames(String type, String ... generics) {
        Ensure.ensureThatArgument((Object)type, (ICondition)Conditions.notNull());
        if (generics.length == 0) {
            return this.codeModel.ref(type);
        }
        JClass[] classes = (JClass[])ArrayUtilities.convert((IConverter)new IConverter<String, JClass, RuntimeException>(){

            public JClass convert(String input) throws RuntimeException {
                return AbstractSourceFactory.this.codeModel.ref(input);
            }
        }, (Object[])generics, JClass.class);
        return this.codeModel.ref(type).narrow(classes);
    }

    protected JClass _class(String typeName, JClass ... generics) {
        return this.codeModel.ref(typeName).narrow(generics);
    }

    protected JType _type(String type, String ... generics) {
        Ensure.ensureThatArgument((Object)type, (ICondition)Conditions.notNull());
        if (generics.length == 0) {
            try {
                return this.codeModel.parseType(type);
            }
            catch (ClassNotFoundException exception) {
                return this.codeModel.ref(type);
            }
        }
        JClass[] classes = (JClass[])ArrayUtilities.convert((IConverter)new IConverter<String, JClass, RuntimeException>(){

            public JClass convert(String input) throws RuntimeException {
                return AbstractSourceFactory.this.codeModel.ref(input);
            }
        }, (Object[])generics, JClass.class);
        return this.codeModel.ref(type).narrow(classes);
    }

    protected JPrimitiveType _void() {
        return this.codeModel.VOID;
    }

    protected JPrimitiveType _boolean() {
        return this.codeModel.BOOLEAN;
    }

    protected JClass _String() {
        return this._classByNames(JavaConstants.JAVA_LANG_STRING, new String[0]);
    }

    protected JClass _Class() {
        return this._classByNames(JavaConstants.JAVA_LANG_CLASS, "?");
    }

    public JExpression format(String string, JExpression ... params) {
        JClass formater = this._classByNames(MessageFormat.class.getName(), new String[0]);
        JInvocation expression = formater.staticInvoke("format").arg(string);
        for (JExpression var : params) {
            expression = expression.arg(var);
        }
        return expression;
    }
}

