/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.SingleStreamCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.tools.generator.java.bean.configuration.Bean;
import net.anwiba.tools.generator.java.bean.factory.BeanBuilderFactory;
import net.anwiba.tools.generator.java.bean.factory.BeanFactory;
import net.anwiba.tools.generator.java.bean.factory.EnsurePredicateFactory;
import net.anwiba.tools.generator.java.bean.writer.SourceCodeWriter;

public class BeanGenerator {
    private final JCodeModel codeModel = new JCodeModel();
    private final EnsurePredicateFactory ensurePredicateFactory;
    private final BeanFactory beanFactory;
    private final BeanBuilderFactory beanBuilderFactory;

    public BeanGenerator(IFactory<String, Class<? extends Annotation>, CreationException> annotationClassfactory) {
        this.ensurePredicateFactory = new EnsurePredicateFactory(this.codeModel, annotationClassfactory);
        this.beanFactory = new BeanFactory(this.codeModel, annotationClassfactory, this.ensurePredicateFactory);
        this.beanBuilderFactory = new BeanBuilderFactory(this.codeModel, annotationClassfactory, this.ensurePredicateFactory);
    }

    public void generate(OutputStream ouputStream) throws IOException {
        this.codeModel.build((CodeWriter)new SingleStreamCodeWriter(ouputStream));
    }

    public void generate(File targetFolder, String comment) throws IOException {
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        SourceCodeWriter sourceCodeWriter = new SourceCodeWriter(targetFolder, comment);
        FileCodeWriter fileCodeWriter = new FileCodeWriter(targetFolder);
        this.codeModel.build((CodeWriter)sourceCodeWriter, (CodeWriter)fileCodeWriter);
    }

    public void add(Bean configuration) throws CreationException {
        this.beanFactory.create(configuration);
        if (configuration.isBuilderEnabled()) {
            this.beanBuilderFactory.create(configuration);
        }
    }

    public class ClosableSourceCodeWriter
    extends SourceCodeWriter
    implements AutoCloseable {
        public ClosableSourceCodeWriter(File target, String comment) throws IOException {
            super(target, comment);
        }
    }
}

