/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.ensure.Conditions;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.ensure.ICondition;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.tools.generator.java.bean.JavaConstants;
import net.anwiba.tools.generator.java.bean.factory.EnsurePredicateFactory;

public class SourceFactoryUtilities {
    public static String createFieldName(String name) {
        return JavaConstants.resevedNames.contains(name) ? MessageFormat.format("_{0}", name) : (JavaConstants.specialNames.containsKey(name) ? JavaConstants.specialNames.get(name) : JavaConstants.specialNames.keySet().stream().filter(c -> name.startsWith((String)c)).findFirst().map(c -> JavaConstants.specialNames.get(c) + JavaConstants.specialNames.get(c)).orElseGet(() -> name));
    }

    @SafeVarargs
    public static JVar addObjectParameter(JMethod method, JFieldVar field, IProcedure<JVar, RuntimeException> ... procedure) {
        if (method == null || field == null) {
            return null;
        }
        JVar param = method.param(8, field.type(), field.name());
        for (IProcedure<JVar, RuntimeException> closure : procedure) {
            closure.execute((Object)param);
        }
        method.body().assign((JAssignmentTarget)JExpr.refthis((String)field.name()), (JExpression)param);
        return param;
    }

    @SafeVarargs
    public static JVar addMapParameter(JMethod method, JFieldVar field, JType nameType, String nameVariableName, JType valueType, String valueVariableName, IProcedure<JVar, RuntimeException> ... procedure) {
        if (method == null || field == null) {
            return null;
        }
        JVar nameParam = method.param(8, nameType, nameVariableName);
        JVar valueParam = method.param(8, valueType, valueVariableName);
        for (IProcedure<JVar, RuntimeException> closure : procedure) {
            closure.execute((Object)nameParam);
            closure.execute((Object)valueParam);
        }
        method.body().add((JStatement)JExpr.refthis((String)field.name()).invoke("put").arg((JExpression)nameParam).arg((JExpression)valueParam));
        return valueParam;
    }

    @SafeVarargs
    public static JVar setMapParameters(JMethod method, JFieldVar field, boolean isClearEnabled, IProcedure<JVar, RuntimeException> ... procedure) {
        if (method == null || field == null) {
            return null;
        }
        JVar param = method.param(8, field.type(), field.name());
        for (IProcedure<JVar, RuntimeException> closure : procedure) {
            closure.execute((Object)param);
        }
        if (isClearEnabled) {
            method.body().add((JStatement)JExpr.refthis((String)field.name()).invoke("clear"));
        }
        method.body().add((JStatement)JExpr.refthis((String)field.name()).invoke("putAll").arg((JExpression)param));
        return param;
    }

    public static JVar addParameter(JMethod method, JFieldVar field) {
        if (method == null || field == null) {
            return null;
        }
        return method.param(8, field.type(), field.name());
    }

    @SafeVarargs
    public static JVar addListParameter(JMethod method, JFieldVar field, boolean isClearEnabled, IProcedure<JVar, RuntimeException> ... procedure) {
        if (method == null || field == null) {
            return null;
        }
        JVar param = method.param(8, field.type(), field.name());
        for (IProcedure<JVar, RuntimeException> closure : procedure) {
            closure.execute((Object)param);
        }
        if (isClearEnabled) {
            method.body().add((JStatement)JExpr.refthis((String)field.name()).invoke("clear"));
        }
        method.body().add((JStatement)JExpr.refthis((String)field.name()).invoke("addAll").arg((JExpression)param));
        return param;
    }

    public static IProcedure<JVar, RuntimeException> createAddIfNullReturnNullClosure(final JMethod method) {
        Ensure.ensureThatArgument((Object)method, (ICondition)Conditions.notNull());
        return new IProcedure<JVar, RuntimeException>(){

            public void execute(JVar param) throws RuntimeException {
                Ensure.ensureThatArgument((Object)param, (ICondition)Conditions.notNull());
                method.body()._if(param.eq(JExpr._null()))._then()._return(JExpr._null());
            }
        };
    }

    public static IProcedure<JVar, RuntimeException> createAddIfNullSetEmptyArrayAndReturnClosure(final JCodeModel codeModel, final JMethod method, final JExpression returnValue) {
        Ensure.ensureThatArgument((Object)method, (ICondition)Conditions.notNull());
        return new IProcedure<JVar, RuntimeException>(){

            public void execute(JVar param) throws RuntimeException {
                Ensure.ensureThatArgument((Object)param, (ICondition)Conditions.notNull());
                ValueConverter valueConverter = new ValueConverter(codeModel);
                JInvocation invocation = JExpr._new((JType)param.type());
                method.body()._if(param.eq(JExpr._null()))._then().block().assign((JAssignmentTarget)JExpr.refthis((String)param.name()), valueConverter.convert(invocation))._return(returnValue);
            }
        };
    }

    public static IProcedure<JVar, RuntimeException> createAddIfNullClearMapAndReturnClosure(final JMethod method, final JExpression returnValue) {
        Ensure.ensureThatArgument((Object)method, (ICondition)Conditions.notNull());
        return new IProcedure<JVar, RuntimeException>(){

            public void execute(JVar param) throws RuntimeException {
                Ensure.ensureThatArgument((Object)param, (ICondition)Conditions.notNull());
                method.body()._if(param.eq(JExpr._null()))._then().block().add((JStatement)JExpr.refthis((String)param.name()).invoke("clear"))._return(returnValue);
            }
        };
    }

    public static IProcedure<JVar, RuntimeException> createAddIfNullClearListAndReturnClosure(final JMethod method, final JExpression returnValue) {
        Ensure.ensureThatArgument((Object)method, (ICondition)Conditions.notNull());
        return new IProcedure<JVar, RuntimeException>(){

            public void execute(JVar param) throws RuntimeException {
                Ensure.ensureThatArgument((Object)param, (ICondition)Conditions.notNull());
                method.body()._if(param.eq(JExpr._null()))._then().block().add((JStatement)JExpr.refthis((String)param.name()).invoke("clear"))._return(returnValue);
            }
        };
    }

    public static IProcedure<JVar, RuntimeException> createAddIfNullReturnClosure(final JMethod method, final JExpression returnValue) {
        Ensure.ensureThatArgument((Object)method, (ICondition)Conditions.notNull());
        return new IProcedure<JVar, RuntimeException>(){

            public void execute(JVar param) throws RuntimeException {
                Ensure.ensureThatArgument((Object)param, (ICondition)Conditions.notNull());
                method.body()._if(param.eq(JExpr._null()))._then()._return(returnValue);
            }
        };
    }

    @SafeVarargs
    public static IProcedure<JVar, RuntimeException> createEnsureArgumentNotNullClosure(final EnsurePredicateFactory ensurePredicateFactory, final JMethod method, final IAcceptor<JVar> ... acceptors) {
        Ensure.ensureThatArgument((Object)ensurePredicateFactory, (ICondition)Conditions.notNull());
        Ensure.ensureThatArgument((Object)method, (ICondition)Conditions.notNull());
        return new IProcedure<JVar, RuntimeException>(){

            public void execute(JVar param) throws RuntimeException {
                Ensure.ensureThatArgument((Object)param, (ICondition)Conditions.notNull());
                for (IAcceptor acceptor : acceptors) {
                    if (acceptor.accept((Object)param)) continue;
                    return;
                }
                method.body().add(ensurePredicateFactory.ensureArgumentNotNull(param));
            }
        };
    }

    public static void adjust(JCodeModel codeModel, JFieldVar field, Object value, boolean isArrayNullable) {
        String typeName;
        ValueConverter valueConverter = new ValueConverter(codeModel);
        if (value instanceof JExpression) {
            field.init(valueConverter.convert(value));
        }
        String string = typeName = field.type().isArray() ? field.type().elementType().name() : field.type().name();
        if (JavaConstants.stringTypes.contains(typeName)) {
            if (!field.type().isArray()) {
                field.init(valueConverter.convert(value));
                return;
            }
            if (value == null && isArrayNullable) {
                field.init(JExpr._null());
                return;
            }
            JArray newArray = JExpr.newArray((JType)field.type().elementType());
            if (value != null) {
                String[] values;
                for (String i : values = (String[])value) {
                    newArray.add(valueConverter.convert(i));
                }
            }
            field.init((JExpression)newArray);
            return;
        }
        if (JavaConstants.floatTypes.contains(typeName)) {
            SourceFactoryUtilities.adjust(codeModel, field, value, isArrayNullable, valueConverter, JavaConstants.JAVA_LANG_FLOAT, Float[].class);
            return;
        }
        if (JavaConstants.doubleTypes.contains(typeName)) {
            SourceFactoryUtilities.adjust(codeModel, field, value, isArrayNullable, valueConverter, JavaConstants.JAVA_LANG_DOUBLE, Double[].class);
            return;
        }
        if (JavaConstants.shortTypes.contains(typeName)) {
            SourceFactoryUtilities.adjust(codeModel, field, value, isArrayNullable, valueConverter, JavaConstants.JAVA_LANG_SHORT, Short[].class);
            return;
        }
        if (JavaConstants.integerTypes.contains(typeName)) {
            SourceFactoryUtilities.adjust(codeModel, field, value, isArrayNullable, valueConverter, JavaConstants.JAVA_LANG_INTEGER, Integer[].class);
            return;
        }
        if (JavaConstants.longTypes.contains(typeName)) {
            SourceFactoryUtilities.adjust(codeModel, field, value, isArrayNullable, valueConverter, JavaConstants.JAVA_LANG_LONG, Long[].class);
            return;
        }
        if (JavaConstants.booleanTypes.contains(typeName)) {
            SourceFactoryUtilities.adjust(codeModel, field, value, isArrayNullable, valueConverter, JavaConstants.JAVA_LANG_BOOLEAN, Boolean[].class);
            return;
        }
        if (JavaConstants.byteTypes.contains(typeName)) {
            SourceFactoryUtilities.adjust(codeModel, field, value, isArrayNullable, valueConverter, JavaConstants.JAVA_LANG_BYTE, Byte[].class);
            return;
        }
        if (JavaConstants.characterTypes.contains(typeName)) {
            SourceFactoryUtilities.adjust(codeModel, field, value, isArrayNullable, valueConverter, JavaConstants.JAVA_LANG_CHARACTER, Character[].class);
            return;
        }
        if (value == null) {
            field.init(JExpr._null());
        }
    }

    public static <C> void adjust(JCodeModel codeModel, JFieldVar field, Object value, boolean isArrayNullable, ValueConverter valueConverter, String className, Class<C[]> clazz) {
        if (!field.type().isArray()) {
            if (field.type().isPrimitive()) {
                if (value == null) {
                    if (field.type().name().equals("short")) {
                        return;
                    }
                    if (field.type().name().equals("int")) {
                        field.init(JExpr.lit((int)0));
                        return;
                    }
                    if (field.type().name().equals("long")) {
                        field.init(JExpr.lit((long)0L));
                        return;
                    }
                    if (field.type().name().equals("float")) {
                        field.init(JExpr.lit((float)Float.NaN));
                        return;
                    }
                    if (field.type().name().equals("double")) {
                        field.init(JExpr.lit((double)Double.NaN));
                        return;
                    }
                    if (field.type().name().equals("boolean")) {
                        field.init(JExpr.lit((boolean)false));
                        return;
                    }
                    if (field.type().name().equals("byte")) {
                        field.init(JExpr.lit((int)11));
                        return;
                    }
                    if (field.type().name().equals("char")) {
                        field.init(JExpr.lit((int)12));
                        return;
                    }
                }
                field.init(valueConverter.convert(value));
                return;
            }
            if (value == null) {
                field.init(JExpr._null());
                return;
            }
            field.init((JExpression)codeModel.ref(className).staticInvoke("valueOf").arg(valueConverter.convert(value)));
            return;
        }
        if (value == null && isArrayNullable) {
            field.init(JExpr._null());
            return;
        }
        JArray newArray = JExpr.newArray((JType)field.type().elementType());
        if (value != null) {
            C[] values;
            for (C i : values = clazz.cast(value)) {
                newArray.add((JExpression)((field.type().isArray() ? field.type().elementType().isPrimitive() : field.type().isPrimitive()) ? valueConverter.convert(i) : codeModel.ref(className).staticInvoke("valueOf").arg(valueConverter.convert(i))));
            }
        }
        field.init((JExpression)newArray);
    }

    public static boolean isInstanceOfList(JType type) {
        try {
            String className = SourceFactoryUtilities.withoutGenerics(type.fullName());
            Class<?> clazz = Class.forName(className);
            return List.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static boolean isInstanceOfMap(JType jclazz) {
        try {
            String className = SourceFactoryUtilities.withoutGenerics(jclazz.fullName());
            Class<?> clazz = Class.forName(className);
            return Map.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static String withoutGenerics(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return name.substring(0, name.indexOf(60));
    }

    public static final class ValueConverter
    implements IConverter<Object, JExpression, RuntimeException> {
        private final JCodeModel codeModel;

        public ValueConverter(JCodeModel codeModel) {
            this.codeModel = codeModel;
        }

        public JExpression convert(Object object) throws RuntimeException {
            if (object == null) {
                return JExpr._null();
            }
            if (object instanceof JExpression) {
                return (JExpression)object;
            }
            if (object instanceof Long) {
                return JExpr.lit((long)((Long)object));
            }
            if (object instanceof Integer) {
                return JExpr.lit((int)((Integer)object));
            }
            if (object instanceof Short) {
                return JExpr.lit((int)((Short)object).shortValue());
            }
            if (object instanceof Double) {
                return JExpr.lit((double)((Double)object));
            }
            if (object instanceof Float) {
                return JExpr.lit((float)((Float)object).floatValue());
            }
            if (object instanceof Character) {
                return JExpr.lit((char)((Character)object).charValue());
            }
            if (object instanceof Byte) {
                return JExpr.lit((int)((Byte)object).byteValue());
            }
            if (object instanceof Boolean) {
                return JExpr.lit((boolean)((Boolean)object));
            }
            if (object instanceof String) {
                return JExpr.lit((String)((String)object));
            }
            if (object.getClass().isArray()) {
                if (object instanceof Short[]) {
                    Short[] values = (Short[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel.SHORT);
                    for (Short value : values) {
                        newArray.add(JExpr.lit((int)value.shortValue()));
                    }
                    return newArray;
                }
                if (object instanceof Integer[]) {
                    Integer[] values = (Integer[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel.INT);
                    for (Integer value : values) {
                        newArray.add(JExpr.lit((int)value));
                    }
                    return newArray;
                }
                if (object instanceof Long[]) {
                    Long[] values = (Long[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel.LONG);
                    for (Long value : values) {
                        newArray.add(JExpr.lit((long)value));
                    }
                    return newArray;
                }
                if (object instanceof Float[]) {
                    Float[] values = (Float[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel.FLOAT);
                    for (Float i : values) {
                        newArray.add(JExpr.lit((float)i.floatValue()));
                    }
                    return newArray;
                }
                if (object instanceof Double[]) {
                    Double[] values = (Double[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel.DOUBLE);
                    for (Double i : values) {
                        newArray.add(JExpr.lit((double)i));
                    }
                    return newArray;
                }
                if (object instanceof Character[]) {
                    Character[] values = (Character[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel.CHAR);
                    for (Character i : values) {
                        newArray.add(JExpr.lit((char)i.charValue()));
                    }
                    return newArray;
                }
                if (object instanceof Byte[]) {
                    Byte[] values = (Byte[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel.BYTE);
                    for (Byte i : values) {
                        newArray.add(JExpr.lit((int)i.byteValue()));
                    }
                    return newArray;
                }
                if (object instanceof Boolean[]) {
                    Boolean[] values = (Boolean[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel.BOOLEAN);
                    for (Boolean i : values) {
                        newArray.add(JExpr.lit((boolean)i));
                    }
                    return newArray;
                }
                if (object instanceof String[]) {
                    String[] values = (String[])object;
                    JArray newArray = JExpr.newArray((JType)this.codeModel._ref(String.class));
                    for (String i : values) {
                        newArray.add(JExpr.lit((String)i));
                    }
                    return newArray;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

