/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JVar;
import java.text.MessageFormat;
import java.util.ArrayList;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.tools.generator.java.bean.configuration.Annotation;
import net.anwiba.tools.generator.java.bean.configuration.Argument;
import net.anwiba.tools.generator.java.bean.configuration.Bean;
import net.anwiba.tools.generator.java.bean.configuration.Builders;
import net.anwiba.tools.generator.java.bean.configuration.Getter;
import net.anwiba.tools.generator.java.bean.configuration.Member;
import net.anwiba.tools.generator.java.bean.configuration.NamedValueProvider;
import net.anwiba.tools.generator.java.bean.configuration.Setter;
import net.anwiba.tools.generator.java.bean.factory.AbstractSourceFactory;
import net.anwiba.tools.generator.java.bean.factory.ConstructorFactory;
import net.anwiba.tools.generator.java.bean.factory.CreatorFactory;
import net.anwiba.tools.generator.java.bean.factory.EnsurePredicateFactory;
import net.anwiba.tools.generator.java.bean.factory.EqualsFactory;
import net.anwiba.tools.generator.java.bean.factory.GetterFactory;
import net.anwiba.tools.generator.java.bean.factory.MemberFactory;
import net.anwiba.tools.generator.java.bean.factory.NamedValueProviderFactory;
import net.anwiba.tools.generator.java.bean.factory.SetterFactory;
import net.anwiba.tools.generator.java.bean.factory.SourceFactoryUtilities;

public class BeanFactory
extends AbstractSourceFactory {
    private final ConstructorFactory constructorFactory;
    private final CreatorFactory creatorFactory;
    private final MemberFactory memberFactory;
    private final GetterFactory getterFactory;
    private final SetterFactory setterFactory;
    private final NamedValueProviderFactory namedValueProviderFactory;
    private final EqualsFactory equalsFactory;

    public BeanFactory(JCodeModel codeModel, EnsurePredicateFactory ensurePredicateFactory) {
        super(codeModel);
        this.constructorFactory = new ConstructorFactory(codeModel, ensurePredicateFactory, false);
        this.memberFactory = new MemberFactory(codeModel);
        this.setterFactory = new SetterFactory(codeModel, ensurePredicateFactory);
        this.getterFactory = new GetterFactory(codeModel);
        this.namedValueProviderFactory = new NamedValueProviderFactory(codeModel);
        this.creatorFactory = new CreatorFactory(codeModel);
        this.equalsFactory = new EqualsFactory(codeModel);
    }

    public void create(Bean configuration) throws CreationException {
        try {
            JDefinedClass bean = this._class(configuration.name(), ClassType.CLASS);
            if (configuration.extend() != null) {
                bean._extends(this._classByNames(configuration.extend(), new String[0]));
            }
            this.annotate((JAnnotatable)bean, configuration.annotations());
            Iterable<JFieldVar> fields = this.members(bean, configuration);
            if (configuration.isMutable()) {
                this.constructorFactory.constructor(configuration, bean, new ArrayList<JFieldVar>());
            }
            if (configuration.members().iterator().hasNext()) {
                this.constructorFactory.constructor(configuration, bean, fields);
            }
            this.creatorFactory.creator(configuration, bean, fields);
            this.equalsFactory.create(configuration, bean, fields);
        }
        catch (JClassAlreadyExistsException exception) {
            throw new CreationException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public Iterable<JFieldVar> members(JDefinedClass instance, Bean configuration) {
        ArrayList<JFieldVar> result = new ArrayList<JFieldVar>();
        for (Member member : configuration.members()) {
            JFieldVar field = this.memberFactory.create(instance, member.annotations(), member.type(), member.name(), member.value(), member.isImutable(), member.isNullable(), configuration.isPrimitivesEnabled(), configuration.isArrayNullable(), configuration.isCollectionNullable());
            result.add(field);
            this.createSetter(instance, configuration, member, field);
            this.createGetter(instance, configuration, member, field);
            this.createNamedValueProvider(instance, configuration, member, field);
        }
        return result;
    }

    public void createNamedValueProvider(JDefinedClass instance, Bean configuration, Member member, JFieldVar field) {
        NamedValueProvider namedValueProvider = configuration.namedValueProvider(member.name());
        if (namedValueProvider != null) {
            this.namedValueProviderFactory.create(instance, namedValueProvider, field);
        }
    }

    public void createGetter(JDefinedClass instance, Bean configuration, Member member, JFieldVar field) {
        Getter getter = member.getter();
        if (getter.isEnabled()) {
            if (getter.isNamedValueGetterEnabled()) {
                NamedValueProvider namedValueProvider = new NamedValueProvider(Builders.type(member.type().generics()[1], new String[0]).build(), member.name(), false, new ArrayList<Annotation>(), MessageFormat.format("{0}Names", getter.name()), new ArrayList<Annotation>(), getter.name());
                this.namedValueProviderFactory.create(instance, namedValueProvider, field);
            }
            this.getterFactory.create(instance, member.isNullable(), configuration.isCollectionNullable(), getter.annotations(), field, getter.name());
        }
    }

    public void createSetter(JDefinedClass instance, Bean configuration, Member member, JFieldVar field) {
        Setter setter = member.setter();
        Argument argument = setter.arguments().iterator().next();
        if (configuration.isMutable() && setter.isEnabled()) {
            if (SourceFactoryUtilities.isInstanceOfMap(field.type())) {
                if (setter.isMultiValue()) {
                    ArrayList<Annotation> annotations = setter.isSingleValue() ? new ArrayList() : setter.annotations();
                    this.setterFactory.create(instance, field, setter.name(), member.isImutable(), member.isNullable(), setter.isInjection(), setter.getInjectionAnnotationName(), annotations, this._type(member.type().generics()[0], new String[0]), "name", this._type(member.type().generics()[1], new String[0]), "value");
                }
                if (setter.isSingleValue()) {
                    JVar parameter = this.setterFactory.create(instance, false, field, setter.name(), member.isImutable(), member.isNullable(), configuration.isArrayNullable(), configuration.isCollectionNullable(), setter.annotations());
                    this.annotate((JAnnotatable)parameter, argument.annotations());
                }
            } else {
                JVar parameter = this.setterFactory.create(instance, false, field, setter.name(), member.isImutable(), member.isNullable(), configuration.isArrayNullable(), configuration.isCollectionNullable(), setter.annotations());
                this.annotate((JAnnotatable)parameter, argument.annotations());
            }
        }
    }
}

