/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.tools.generator.java.bean.configuration.Annotation;
import net.anwiba.tools.generator.java.bean.configuration.Argument;
import net.anwiba.tools.generator.java.bean.configuration.Getter;
import net.anwiba.tools.generator.java.bean.configuration.Member;
import net.anwiba.tools.generator.java.bean.configuration.Setter;
import net.anwiba.tools.generator.java.bean.configuration.Type;

public class MemberBuilder {
    private final String name;
    private final Type type;
    private boolean isNullable = true;
    private boolean isSetterEnabled = true;
    private boolean isGetterEnabled = true;
    private Object value;
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final List<Annotation> setterAnnotations = new ArrayList<Annotation>();
    private final List<Annotation> setterArgumentAnnotations = new ArrayList<Annotation>();
    private final List<Annotation> getterAnnotations = new ArrayList<Annotation>();
    private boolean isMultiValue = false;
    private final boolean isSingleValue = true;
    private boolean isImutable = false;

    MemberBuilder(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public Member build() {
        HashMap<String, List<Annotation>> map = new HashMap<String, List<Annotation>>();
        map.put(this.name, this.setterArgumentAnnotations);
        Setter setter = new Setter(MemberBuilder.createSetterName(this.name), this.isSetterEnabled, true, this.isMultiValue, false, null, this.setterAnnotations, new Argument(this.type, this.name, this.setterArgumentAnnotations), map);
        Getter getter = new Getter(MemberBuilder.createGetterName(this.type, this.name), this.isGetterEnabled, false, this.getterAnnotations);
        return new Member(this.type, this.name, this.value, this.isNullable, this.isImutable, this.annotations, setter, getter);
    }

    public MemberBuilder value(String value) {
        this.value = value;
        return this;
    }

    public MemberBuilder value(String[] values) {
        this.value = values;
        return this;
    }

    public MemberBuilder value(short value) {
        this.value = value;
        return this;
    }

    public MemberBuilder value(short[] values) {
        this.value = ArrayUtilities.objects((short[])values);
        return this;
    }

    public MemberBuilder value(int value) {
        this.value = value;
        return this;
    }

    public MemberBuilder value(int[] values) {
        this.value = ArrayUtilities.objects((int[])values);
        return this;
    }

    public MemberBuilder value(long value) {
        this.value = value;
        return this;
    }

    public MemberBuilder value(long[] values) {
        this.value = ArrayUtilities.objects((long[])values);
        return this;
    }

    public MemberBuilder value(float value) {
        this.value = Float.valueOf(value);
        return this;
    }

    public MemberBuilder value(float[] values) {
        this.value = ArrayUtilities.objects((float[])values);
        return this;
    }

    public MemberBuilder value(double value) {
        this.value = value;
        return this;
    }

    public MemberBuilder value(double[] values) {
        this.value = ArrayUtilities.objects((double[])values);
        return this;
    }

    public MemberBuilder value(char value) {
        this.value = Character.valueOf(value);
        return this;
    }

    public MemberBuilder value(char[] values) {
        this.value = ArrayUtilities.objects((char[])values);
        return this;
    }

    public MemberBuilder value(byte value) {
        this.value = value;
        return this;
    }

    public MemberBuilder value(byte[] values) {
        this.value = ArrayUtilities.objects((byte[])values);
        return this;
    }

    public MemberBuilder value(boolean value) {
        this.value = value;
        return this;
    }

    public MemberBuilder value(boolean[] values) {
        this.value = ArrayUtilities.objects((boolean[])values);
        return this;
    }

    public MemberBuilder isMultiValue(boolean isMultiValue) {
        this.isMultiValue = isMultiValue;
        return this;
    }

    public MemberBuilder isSetterEnabled(boolean isSetterEnabled) {
        this.isSetterEnabled = isSetterEnabled;
        return this;
    }

    public MemberBuilder isGetterEnabled(boolean isGetterEnabled) {
        this.isGetterEnabled = isGetterEnabled;
        return this;
    }

    public MemberBuilder isNullable(boolean isNullable) {
        this.isNullable = isNullable;
        return this;
    }

    public MemberBuilder setterArgumentAnnotation(Annotation annotation) {
        this.setterArgumentAnnotations.add(annotation);
        return this;
    }

    public MemberBuilder isImutable(boolean isImutable) {
        this.isImutable = isImutable;
        return this;
    }

    public MemberBuilder annotation(Annotation annotations) {
        if (annotations == null) {
            return this;
        }
        this.annotations.add(annotations);
        return this;
    }

    public MemberBuilder setterAnnotation(Annotation annotations) {
        if (annotations == null) {
            return this;
        }
        this.setterAnnotations.add(annotations);
        return this;
    }

    public MemberBuilder getterAnnotation(Annotation annotations) {
        if (annotations == null) {
            return this;
        }
        this.getterAnnotations.add(annotations);
        return this;
    }

    public static String createSetterName(String name) {
        Ensure.ensureArgumentNotNull((Object)name);
        return MemberBuilder.createMethodName("set", name);
    }

    public static String createGetterName(Type type, String name) {
        if (type.name().equals("boolean")) {
            if (name.startsWith("is")) {
                return MemberBuilder.createMethodName(null, name);
            }
            return MemberBuilder.createMethodName("is", name);
        }
        if (name.equalsIgnoreCase("class")) {
            return "getCLASS";
        }
        return MemberBuilder.createMethodName("get", name);
    }

    private static String createMethodName(String prefix, String name) {
        if (StringUtilities.isNullOrTrimmedEmpty((String)prefix)) {
            return name;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(name.substring(0, 1).toUpperCase());
        builder.append(name.substring(1, name.length()));
        return builder.toString();
    }
}

