/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.tools.generator.java.bean.configuration.Annotation;
import net.anwiba.tools.generator.java.bean.factory.AbstractSourceFactory;
import net.anwiba.tools.generator.java.bean.factory.EnsurePredicateFactory;
import net.anwiba.tools.generator.java.bean.factory.SourceFactoryUtilities;

public class SetterFactory
extends AbstractSourceFactory {
    private final EnsurePredicateFactory ensurePredicateFactory;
    private final JCodeModel codeModel;

    public SetterFactory(JCodeModel codeModel, EnsurePredicateFactory ensurePredicateFactory) {
        super(codeModel);
        this.codeModel = codeModel;
        this.ensurePredicateFactory = ensurePredicateFactory;
    }

    public void create(JDefinedClass instance, JFieldVar field, String name, boolean isImutable, boolean isNullable, List<Annotation> annotations, JType nameType, String nameVar, JType valueType, String value) {
        this.mapSetter(instance, field, name, isImutable, isNullable, annotations, nameType, nameVar, valueType, value);
    }

    private JVar mapSetter(JDefinedClass instance, JFieldVar field, String name, boolean isImutable, boolean isNullable, List<Annotation> annotationConfigurations, JType nameVariableType, final String nameVariableName, JType valueVariableType, String valueVariableName) {
        JMethod method = instance.method(1, (JType)this._void(), name);
        this.annotate((JAnnotatable)method, annotationConfigurations);
        if (isImutable) {
            return SourceFactoryUtilities.addParameter(method, field);
        }
        if (isNullable) {
            return SourceFactoryUtilities.addMapParameter(method, field, nameVariableType, nameVariableName, valueVariableType, valueVariableName, SourceFactoryUtilities.createEnsureArgumentNotNullClosure(this.ensurePredicateFactory, method, new IAcceptor<JVar>(){

                public boolean accept(JVar value) {
                    return value.name().equals(nameVariableName);
                }
            }));
        }
        return SourceFactoryUtilities.addMapParameter(method, field, nameVariableType, nameVariableName, valueVariableType, valueVariableName, SourceFactoryUtilities.createEnsureArgumentNotNullClosure(this.ensurePredicateFactory, method, new IAcceptor[0]));
    }

    public JVar create(JDefinedClass instance, boolean returnInstance, JFieldVar field, String name, boolean isImutable, boolean isNullable, boolean isArrayNullable, boolean isCollectionNullable, List<Annotation> annotations) {
        JMethod method = instance.method(1, (JType)(returnInstance ? instance : this._void()), name);
        this.annotate((JAnnotatable)method, annotations);
        JVar variable = this.addParameter(method, (JExpression)(returnInstance ? JExpr._this() : null), field, isImutable, isNullable, isArrayNullable, isCollectionNullable);
        if (returnInstance) {
            method.body()._return(JExpr._this());
        }
        return variable;
    }

    private JVar addParameter(JMethod method, JExpression returnValue, JFieldVar field, boolean isImutable, boolean isNullable, boolean isArrayNullable, boolean isCollectionNullable) {
        if (isImutable) {
            return SourceFactoryUtilities.addParameter(method, field);
        }
        if (SourceFactoryUtilities.isInstanceOfMap(field.type())) {
            return this.mapSetter(method, returnValue, field, isNullable);
        }
        if (SourceFactoryUtilities.isInstanceOfList(field.type())) {
            return this.listSetter(method, returnValue, field, isNullable, isCollectionNullable);
        }
        return this.objectSetter(method, returnValue, field, isNullable, isArrayNullable);
    }

    private JVar mapSetter(JMethod method, JExpression returnValue, JFieldVar field, boolean isNullable) {
        if (isNullable) {
            return SourceFactoryUtilities.setMapParameters(method, field, true, SourceFactoryUtilities.createAddIfNullClearMapAndReturnClosure(method, returnValue));
        }
        return SourceFactoryUtilities.setMapParameters(method, field, true, SourceFactoryUtilities.createEnsureArgumentNotNullClosure(this.ensurePredicateFactory, method, new IAcceptor[0]));
    }

    private JVar listSetter(JMethod method, JExpression returnValue, JFieldVar field, boolean isNullable, boolean isCollectionNullable) {
        if (isNullable) {
            if (!isCollectionNullable) {
                return SourceFactoryUtilities.addListParameter(method, field, true, SourceFactoryUtilities.createAddIfNullClearListAndReturnClosure(method, returnValue));
            }
            return SourceFactoryUtilities.addListParameter(method, field, true, SourceFactoryUtilities.createAddIfNullReturnClosure(method, returnValue));
        }
        return SourceFactoryUtilities.addListParameter(method, field, true, SourceFactoryUtilities.createEnsureArgumentNotNullClosure(this.ensurePredicateFactory, method, new IAcceptor[0]));
    }

    private JVar objectSetter(JMethod method, JExpression returnValue, JFieldVar field, boolean isNullable, boolean isArrayNullable) {
        if (isNullable) {
            if (!isArrayNullable && field.type().isArray()) {
                return SourceFactoryUtilities.addObjectParameter(method, field, SourceFactoryUtilities.createAddIfNullSetEmptyArrayAndReturnClosure(this.codeModel, method, returnValue));
            }
            return SourceFactoryUtilities.addObjectParameter(method, field, new IProcedure[0]);
        }
        return SourceFactoryUtilities.addObjectParameter(method, field, SourceFactoryUtilities.createEnsureArgumentNotNullClosure(this.ensurePredicateFactory, method, new IAcceptor[0]));
    }
}

