/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import java.util.ArrayList;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.tools.generator.java.bean.configuration.Bean;
import net.anwiba.tools.generator.java.bean.configuration.Member;
import net.anwiba.tools.generator.java.bean.configuration.Setter;
import net.anwiba.tools.generator.java.bean.factory.AbstractSourceFactory;
import net.anwiba.tools.generator.java.bean.factory.BuildMethodFactory;
import net.anwiba.tools.generator.java.bean.factory.ConstructorFactory;
import net.anwiba.tools.generator.java.bean.factory.EnsurePredicateFactory;
import net.anwiba.tools.generator.java.bean.factory.MemberFactory;
import net.anwiba.tools.generator.java.bean.factory.SetterFactory;

public class BeanBuilderFactory
extends AbstractSourceFactory {
    private final SetterFactory setterFactory;
    private final MemberFactory memberFactory;
    private final BuildMethodFactory buildMethodFactory;
    private final ConstructorFactory constructorFactory;

    public BeanBuilderFactory(JCodeModel codeModel, EnsurePredicateFactory ensurePredicateFactory) {
        super(codeModel);
        this.setterFactory = new SetterFactory(codeModel, ensurePredicateFactory);
        this.memberFactory = new MemberFactory(codeModel);
        this.buildMethodFactory = new BuildMethodFactory(codeModel);
        this.constructorFactory = new ConstructorFactory(codeModel, ensurePredicateFactory, true);
    }

    public void create(Bean configuration) throws CreationException {
        try {
            JDefinedClass beanBuilder = this._class(String.valueOf(configuration.name()) + "Builder", ClassType.CLASS);
            this.annotate((JAnnotatable)beanBuilder, configuration.annotations());
            Iterable<JFieldVar> fields = this.setters(beanBuilder, configuration);
            this.constructorFactory.constructor(configuration, beanBuilder, fields);
            this.buildMethodFactory.create(beanBuilder, configuration.name(), fields);
        }
        catch (JClassAlreadyExistsException exception) {
            throw new CreationException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public Iterable<JFieldVar> setters(JDefinedClass instance, Bean configuration) {
        ArrayList<JFieldVar> result = new ArrayList<JFieldVar>();
        for (Member member : configuration.members()) {
            if (!member.setter().isEnabled()) continue;
            JFieldVar field = this.memberFactory.create(instance, member.annotations(), member.type(), member.name(), member.value(), false, member.isNullable(), configuration.isPrimitivesEnabled(), configuration.isArrayNullable(), configuration.isCollectionNullable());
            result.add(field);
            if (!member.isNullable()) continue;
            Setter setter = member.setter();
            this.setterFactory.create(instance, true, field, setter.name(), false, member.isNullable(), configuration.isArrayNullable(), configuration.isCollectionNullable(), setter.annotations());
        }
        return result;
    }
}

