/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import java.text.MessageFormat;
import net.anwiba.commons.ensure.Conditions;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.ensure.ICondition;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.tools.generator.java.bean.JavaConstants;
import net.anwiba.tools.generator.java.bean.configuration.Annotation;
import net.anwiba.tools.generator.java.bean.configuration.Parameter;
import net.anwiba.tools.generator.java.bean.configuration.Type;
import net.anwiba.tools.generator.java.bean.value.IValueTypeVisitor;

public class AbstractSourceFactory {
    private final JCodeModel codeModel;

    public AbstractSourceFactory(JCodeModel codeModel) {
        Ensure.ensureThatArgument((Object)codeModel, (ICondition)Conditions.notNull());
        this.codeModel = codeModel;
    }

    protected void annotate(JAnnotatable annotatable, Iterable<Annotation> annotationConfigurations) {
        Ensure.ensureThatArgument((Object)annotatable, (ICondition)Conditions.notNull());
        Ensure.ensureThatArgument(annotationConfigurations, (ICondition)Conditions.notNull());
        for (Annotation annotationConfiguration : annotationConfigurations) {
            this.annotate(annotatable, annotationConfiguration);
        }
    }

    protected void annotate(JAnnotatable annotatable, Annotation annotation) {
        Ensure.ensureThatArgument((Object)annotatable, (ICondition)Conditions.notNull());
        Ensure.ensureThatArgument((Object)annotation, (ICondition)Conditions.notNull());
        final JAnnotationUse annotate = annotatable.annotate(this._class(annotation.name(), new String[0]));
        Iterable<Parameter> parameters = annotation.parameters();
        for (final Parameter parameter : parameters) {
            for (final Object value : parameter.values()) {
                parameter.type().accept(new IValueTypeVisitor(){

                    @Override
                    public void string() {
                        annotate.param(parameter.name(), (String)String.class.cast(value));
                    }

                    @Override
                    public void integer() {
                        annotate.param(parameter.name(), ((Integer)Integer.class.cast(value)).intValue());
                    }

                    @Override
                    public void clazz() {
                        annotate.param(parameter.name(), (Class)Class.class.cast(value));
                    }
                });
            }
        }
    }

    protected JDefinedClass _class(String name, ClassType clazz) throws JClassAlreadyExistsException {
        Ensure.ensureThatArgument((Object)name, (ICondition)Conditions.notNull());
        Ensure.ensureThatArgument((Object)clazz, (ICondition)Conditions.notNull());
        return this.codeModel._class(name, ClassType.CLASS);
    }

    protected JType _class(Type configuration, boolean isPrimitivesEnabled) {
        if (!isPrimitivesEnabled && JavaConstants.primitives.contains(configuration.name()) && configuration.dimension() == 0) {
            JType _class = this._type(JavaConstants.primitiveClasses.get(configuration.name()), new String[0]);
            int i = 0;
            while (i < configuration.dimension()) {
                _class = _class.array();
                ++i;
            }
            return _class;
        }
        JType _class = this._type(configuration.name(), configuration.generics());
        int i = 0;
        while (i < configuration.dimension()) {
            _class = _class.array();
            ++i;
        }
        return _class;
    }

    protected JClass _class(String type, String ... generics) {
        Ensure.ensureThatArgument((Object)type, (ICondition)Conditions.notNull());
        if (generics.length == 0) {
            return this.codeModel.ref(type);
        }
        JClass[] classes = (JClass[])ArrayUtilities.convert((IConverter)new IConverter<String, JClass, RuntimeException>(){

            public JClass convert(String input) throws RuntimeException {
                return AbstractSourceFactory.this.codeModel.ref(input);
            }
        }, (Object[])generics, JClass.class);
        return this.codeModel.ref(type).narrow(classes);
    }

    protected JType _type(String type, String ... generics) {
        Ensure.ensureThatArgument((Object)type, (ICondition)Conditions.notNull());
        if (generics.length == 0) {
            try {
                return this.codeModel.parseType(type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.codeModel.ref(type);
            }
        }
        JClass[] classes = (JClass[])ArrayUtilities.convert((IConverter)new IConverter<String, JClass, RuntimeException>(){

            public JClass convert(String input) throws RuntimeException {
                return AbstractSourceFactory.this.codeModel.ref(input);
            }
        }, (Object[])generics, JClass.class);
        return this.codeModel.ref(type).narrow(classes);
    }

    protected JPrimitiveType _void() {
        return this.codeModel.VOID;
    }

    public JExpression format(String string, JExpression ... params) {
        JClass formater = this._class(MessageFormat.class.getName(), new String[0]);
        JInvocation expression = formater.staticInvoke("format").arg(string);
        JExpression[] jExpressionArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            JExpression var = jExpressionArray[n2];
            expression = expression.arg(var);
            ++n2;
        }
        return expression;
    }
}

