/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.anwiba.commons.ensure.Conditions;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.ensure.ICondition;
import net.anwiba.tools.generator.java.bean.configuration.Parameter;
import net.anwiba.tools.generator.java.bean.value.ValueType;

public class Parameters {
    private final List<String> names = new ArrayList<String>();
    private final Map<String, Set<Object>> values = new HashMap<String, Set<Object>>();
    private final Map<String, ValueType> types = new HashMap<String, ValueType>();

    public void add(String name, Object value, ValueType type) {
        Ensure.ensureArgumentNotNull((Object)name);
        Ensure.ensureArgumentNotNull((Object)value);
        Ensure.ensureArgumentNotNull((Object)((Object)type));
        if (!this.values.containsKey(name)) {
            this.names.add(name);
            this.values.put(name, new HashSet());
            this.types.put(name, type);
        }
        Ensure.ensureThatArgument((Object)((Object)type), (ICondition)Conditions.equalTo((Object)((Object)this.types.get(name))));
        Set<Object> set = this.values.get(name);
        set.add(value);
    }

    public Iterable<Parameter> parameters() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (String name : this.names) {
            list.add(new Parameter(name, this.types.get(name), this.values.get(name)));
        }
        return list;
    }
}

