/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.tools.generator.java.bean.JavaConstants;
import net.anwiba.tools.generator.java.bean.configuration.Argument;
import net.anwiba.tools.generator.java.bean.configuration.Bean;
import net.anwiba.tools.generator.java.bean.configuration.Creator;
import net.anwiba.tools.generator.java.bean.configuration.Member;
import net.anwiba.tools.generator.java.bean.factory.AbstractSourceFactory;
import net.anwiba.tools.generator.java.bean.factory.MemberFactory;

public class CreatorFactory
extends AbstractSourceFactory {
    public static final Set<String> stringTypes = new HashSet<String>();
    private final MemberFactory memberFactory;

    static {
        stringTypes.add(String.class.getName());
        stringTypes.add(String.class.getSimpleName());
    }

    public CreatorFactory(JCodeModel codeModel) {
        super(codeModel);
        this.memberFactory = new MemberFactory(codeModel);
    }

    public void creator(Bean configuration, JDefinedClass bean, Iterable<JFieldVar> fields) throws CreationException {
        Creator creator = configuration.creator();
        if (creator == null) {
            return;
        }
        Member member = configuration.member(creator.parameter());
        if (member != null && !stringTypes.contains(member.type().name())) {
            throw new CreationException(MessageFormat.format("parameter name ''{0}'' is not from type java.lang.String.", member.name()));
        }
        if (creator.factory() != null) {
            this.createFactoryCreateMethod(creator, bean);
            return;
        }
        JFieldVar classes = this.memberFactory.mapStaticMember(bean, (JType)this._classByNames(JavaConstants.JAVA_UTIL_HASHMAP, JavaConstants.JAVA_LANG_STRING, JavaConstants.JAVA_LANG_CLASS), "_classes", new String[]{JavaConstants.JAVA_LANG_STRING, JavaConstants.JAVA_LANG_CLASS});
        this.createTypeCreateMethod(configuration, creator, bean);
        this.createCreateBeanMethod(bean);
        this.createCreateClassMethod(bean, classes);
        this.createIsNullOrTrimmedEmpty(bean);
        this.createSetFirstCharacterToUpperCase(bean);
    }

    private void createFactoryCreateMethod(Creator creator, JDefinedClass bean) throws CreationException {
        JMethod method = bean.method(17, (JType)bean, creator.name());
        this.annotate((JAnnotatable)method, creator.annotations());
        Iterable<Argument> arguments = creator.arguments();
        JVar factory = method.param(this._class(creator.factory().type(), true), creator.factory().name());
        this.annotate((JAnnotatable)factory, creator.factory().annotations());
        JInvocation invoke = factory.invoke("create");
        for (Argument argument : arguments) {
            JVar type = method.param(this._class(argument.type(), true), argument.name());
            this.annotate((JAnnotatable)type, argument.annotations());
            invoke.arg((JExpression)type);
        }
        method.body()._return((JExpression)invoke);
    }

    private void createTypeCreateMethod(Bean configuration, Creator creator, JDefinedClass bean) throws CreationException {
        JMethod method = bean.method(17, (JType)bean, creator.name());
        this.annotate((JAnnotatable)method, creator.annotations());
        Iterable<Argument> arguments = creator.arguments();
        Argument argument = arguments.iterator().next();
        JVar type = method.param(this._class(argument.type(), true), argument.name());
        this.annotate((JAnnotatable)type, argument.annotations());
        method.body()._if(this.isNullOrTrimmedEmpty(type))._then()._return((JExpression)JExpr._new((JClass)bean));
        JVar clazz = method.body().decl((JType)this._classByNames(Class.class.getName(), MessageFormat.format("? extends {0}", bean.name())), "clazz", this._createClass((JExpression)type));
        JBlock block = method.body()._if(clazz.ne(JExpr._null()))._then();
        block._return(this._createBean((JExpression)clazz));
        method.body().assign((JAssignmentTarget)clazz, this._createClass(this.lowerCase((JExpression)type)));
        block = method.body()._if(clazz.ne(JExpr._null()))._then();
        block._return(this._createBean((JExpression)clazz));
        JVar className = method.body().decl((JType)this._String(), "className", this.format("{0}{1}", new JExpression[]{type, JExpr.lit((String)bean.name())}));
        method.body().assign((JAssignmentTarget)clazz, this._createClass((JExpression)className));
        block = method.body()._if(clazz.ne(JExpr._null()))._then();
        block._return(this._createBean((JExpression)clazz));
        method.body().assign((JAssignmentTarget)className, this.format("{0}{1}", this.lowerCase((JExpression)type), JExpr.lit((String)bean.name())));
        method.body().assign((JAssignmentTarget)clazz, this._createClass((JExpression)className));
        block = method.body()._if(clazz.ne(JExpr._null()))._then();
        block._return(this._createBean((JExpression)clazz));
        method.body()._return((JExpression)JExpr._new((JClass)bean));
    }

    private JExpression lowerCase(JExpression type) {
        return type.invoke("toLowerCase");
    }

    private JExpression _createClass(JExpression type) {
        return JExpr.invoke((String)"_createClass").arg(type);
    }

    private JExpression _createBean(JExpression type) {
        return JExpr.invoke((String)"_createBean").arg(type);
    }

    public JMethod createCreateBeanMethod(JDefinedClass bean) {
        JMethod method = bean.method(20, (JType)bean, "_createBean");
        JVar classParameter = method.param(8, (JType)this._classByNames(Class.class.getName(), MessageFormat.format("? extends {0}", bean.name())), "clazz");
        JBlock methodBody = method.body();
        JConditional ifBlock = methodBody._if(this._classByNames(System.class.getName(), new String[0]).staticInvoke("getSecurityManager").eq(JExpr._null()));
        this.add(bean, classParameter, ifBlock._then()._try());
        JDefinedClass anonymousClass = this.getCodeModel().anonymousClass(this._classByNames(PrivilegedAction.class.getName(), bean.name()));
        JMethod anonymousClassMethod = anonymousClass.method(1, (JType)bean, "run");
        this.add(bean, classParameter, anonymousClassMethod.body()._try());
        methodBody._return((JExpression)this._classByNames(AccessController.class.getName(), new String[0]).staticInvoke("doPrivileged").arg((JExpression)JExpr._new((JClass)anonymousClass)));
        return method;
    }

    private void add(JDefinedClass bean, JVar classParameter, JTryBlock tryBlock) {
        JBlock tryBody = tryBlock.body();
        JClass invokerClass = this._classByNames(Constructor.class.getName(), MessageFormat.format("? extends {0}", bean.name()));
        JVar invoker = tryBody.decl((JType)invokerClass, "constructor", (JExpression)classParameter.invoke("getDeclaredConstructor").arg((JExpression)JExpr.newArray((JType)this._classByNames(Class.class.getName(), new String[0]), (int)0)));
        tryBody._return((JExpression)invoker.invoke("newInstance"));
        this.addRuntimeExceptionThrowingCatchTo(tryBlock, this._classByNames(InstantiationException.class.getName(), new String[0]));
        this.addRuntimeExceptionThrowingCatchTo(tryBlock, this._classByNames(NoSuchMethodException.class.getName(), new String[0]));
        this.addRuntimeExceptionThrowingCatchTo(tryBlock, this._classByNames(InvocationTargetException.class.getName(), new String[0]));
        this.addRuntimeExceptionThrowingCatchTo(tryBlock, this._classByNames(IllegalAccessException.class.getName(), new String[0]));
        this.addRuntimeExceptionThrowingCatchTo(tryBlock, this._classByNames(IllegalArgumentException.class.getName(), new String[0]));
    }

    private void addRuntimeExceptionThrowingCatchTo(JTryBlock block, JClass exceptionClass) {
        JCatchBlock catchBlock = block._catch(exceptionClass);
        JVar catchedException = catchBlock.param("exception");
        JBlock catchBody = catchBlock.body();
        catchBody._throw((JExpression)JExpr._new((JClass)this._classByNames(RuntimeException.class.getName(), new String[0])).arg((JExpression)catchedException));
    }

    public JMethod createCreateClassMethod(JDefinedClass bean, JFieldVar classes) {
        JClass returnClazz = this._classByNames(Class.class.getName(), MessageFormat.format("? extends {0}", bean.name()));
        JMethod method = bean.method(148, (JType)returnClazz, "_createClass");
        JVar type = method.param(String.class, "type");
        method.body()._if((JExpression)classes.invoke("containsKey").arg((JExpression)type))._then()._return((JExpression)JExpr.cast((JType)returnClazz, (JExpression)classes.invoke("get").arg((JExpression)type)));
        JTryBlock _try = method.body()._try();
        JBlock body = _try.body();
        JVar packageName = body.decl((JType)this._String(), "packageName", (JExpression)this.packageName(bean));
        JVar typeName = body.decl((JType)this._String(), "typeName", this.setFirstCharacterToUpperCase(type));
        JVar className = body.decl((JType)this._String(), "className", this.format("{0}.{1}", new JExpression[]{packageName, typeName}));
        JVar clazz = body.decl((JType)this._Class(), "clazz", this.classForName(className));
        JExpression condition = this.isAssignableFrom(bean, (JExpression)clazz).not();
        JBlock block = body._if(condition)._then().block();
        block.invoke((JExpression)classes, "put").arg((JExpression)type).arg(JExpr._null());
        block._return(JExpr._null());
        body.invoke((JExpression)classes, "put").arg((JExpression)type).arg((JExpression)clazz);
        body._return((JExpression)JExpr.cast((JType)returnClazz, (JExpression)clazz));
        JCatchBlock _catch = _try._catch(this._classByNames(ClassNotFoundException.class.getName(), new String[0]));
        _catch.param("exception");
        _catch.body().invoke((JExpression)classes, "put").arg((JExpression)type).arg(JExpr._null());
        _catch.body()._return(JExpr._null());
        return method;
    }

    private JMethod createIsNullOrTrimmedEmpty(JDefinedClass bean) {
        JMethod method = bean.method(20, (JType)this._boolean(), "_isNullOrTrimmedEmpty");
        JVar value = method.param(String.class, "value");
        method.body()._return(value.eq(JExpr._null()).cor((JExpression)value.invoke("trim").invoke("isEmpty")));
        return method;
    }

    private JMethod createSetFirstCharacterToUpperCase(JDefinedClass bean) {
        JMethod method = bean.method(20, (JType)this._String(), "_setFirstCharacterToUpperCase");
        JVar value = method.param(String.class, "value");
        JBlock body = method.body();
        body._if(value.eq(JExpr._null()).cor((JExpression)value.invoke("trim").invoke("isEmpty")))._then()._return(JExpr._null());
        JInvocation firstCharacter = value.invoke("substring").arg(JExpr.lit((int)0)).arg(JExpr.lit((int)1)).invoke("toUpperCase");
        JInvocation restCharacters = value.invoke("substring").arg(JExpr.lit((int)1)).arg((JExpression)value.invoke("length"));
        body._return(firstCharacter.plus((JExpression)restCharacters));
        return method;
    }

    private JExpression setFirstCharacterToUpperCase(JVar className) {
        return JExpr.invoke((String)"_setFirstCharacterToUpperCase").arg((JExpression)className);
    }

    private JExpression isNullOrTrimmedEmpty(JVar className) {
        return JExpr.invoke((String)"_isNullOrTrimmedEmpty").arg((JExpression)className);
    }

    private JExpression classForName(JVar className) {
        return this._classByNames(Class.class.getName(), new String[0]).staticInvoke("forName").arg((JExpression)className);
    }

    private JInvocation isAssignableFrom(JDefinedClass bean, JExpression clazz) {
        return JExpr.dotclass((JClass)bean).invoke("isAssignableFrom").arg(clazz);
    }

    private JInvocation packageName(JDefinedClass bean) {
        return JExpr.dotclass((JClass)bean).invoke("getPackage").invoke("getName");
    }
}

