/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.factory;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.tools.generator.java.bean.JavaConstants;
import net.anwiba.tools.generator.java.bean.configuration.Annotation;
import net.anwiba.tools.generator.java.bean.configuration.Type;
import net.anwiba.tools.generator.java.bean.factory.AbstractSourceFactory;
import net.anwiba.tools.generator.java.bean.factory.SourceFactoryUtilities;

public class MemberFactory
extends AbstractSourceFactory {
    private final JCodeModel codeModel;

    public MemberFactory(JCodeModel codeModel) {
        super(codeModel);
        this.codeModel = codeModel;
    }

    public JFieldVar create(JDefinedClass instance, Iterable<Annotation> annotation, Type type, String name, Object value, boolean isImutable, boolean isNullable, boolean isPrimitivesEnabled, boolean isArrayNullable, boolean isCollectionNullable) throws CreationException {
        String fieldName = SourceFactoryUtilities.createFieldName(name);
        JType clazz = this._class(type, isPrimitivesEnabled);
        JFieldVar field = SourceFactoryUtilities.isInstanceOfMap(clazz) ? this.mapMember(instance, clazz, fieldName, type.generics()) : (SourceFactoryUtilities.isInstanceOfList(clazz) ? this.listMember(instance, clazz, fieldName, type.generics(), isNullable, isCollectionNullable) : this.objectMember(instance, clazz, fieldName, value, isImutable, isArrayNullable));
        this.annotate((JAnnotatable)field, annotation);
        return field;
    }

    private JFieldVar listMember(JDefinedClass instance, JType clazz, String name, String[] generics, boolean isNullable, boolean isCollectionNullable) {
        JFieldVar field = instance.field(12, clazz, name);
        if (isNullable && isCollectionNullable) {
            return field;
        }
        JType type = SourceFactoryUtilities.withoutGenerics(clazz.fullName()).startsWith(JavaConstants.JAVA_UTIL_LIST) ? this._type(JavaConstants.JAVA_UTIL_ARRAYLIST, generics) : clazz;
        field.init((JExpression)JExpr._new((JType)type));
        return field;
    }

    private JFieldVar objectMember(JDefinedClass instance, JType clazz, String name, Object value, boolean isImutable, boolean isArrayNullable) {
        JFieldVar field = isImutable ? instance.field(12, clazz, name) : instance.field(4, clazz, name);
        SourceFactoryUtilities.adjust(this.codeModel, field, value, isArrayNullable);
        return field;
    }

    public JFieldVar mapStaticMember(JDefinedClass instance, JType clazz, String name, String[] generics) {
        JFieldVar field = instance.field(28, clazz, name);
        return this.mapMember(field, clazz, generics);
    }

    public JFieldVar mapMember(JFieldVar field, JType clazz, String[] generics) {
        JType type = SourceFactoryUtilities.withoutGenerics(clazz.fullName()).startsWith(JavaConstants.JAVA_UTIL_MAP) ? this._type(JavaConstants.JAVA_UTIL_LINKHASHMAP, generics) : clazz;
        field.init((JExpression)JExpr._new((JType)type));
        return field;
    }

    public JFieldVar mapMember(JDefinedClass instance, JType clazz, String name, String[] generics) {
        JFieldVar field = instance.field(12, clazz, name);
        return this.mapMember(field, clazz, generics);
    }
}

