/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.generator.java.bean.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.tools.generator.java.bean.configuration.Annotation;
import net.anwiba.tools.generator.java.bean.configuration.Creator;
import net.anwiba.tools.generator.java.bean.configuration.Member;
import net.anwiba.tools.generator.java.bean.configuration.NamedValueProvider;

public class Bean {
    private final String name;
    private final List<Member> members = new ArrayList<Member>();
    private final Map<String, Member> membersByName = new HashMap<String, Member>();
    private final Map<String, NamedValueProvider> namedValueProviders = new HashMap<String, NamedValueProvider>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final boolean mutable;
    private final String extend;
    private final String comment;
    private final boolean arrayNullable;
    private final boolean collectionNullable;
    private final Creator creator;
    private final boolean equalsEnabled;
    private final boolean primitivesEnabled;
    private final boolean isBuilderEnabled;

    Bean(String comment, String name, String extend, List<Annotation> annotationConfigurations, boolean mutable, boolean isBuilderEnabled, boolean arrayNullable, boolean collectionNullable, List<Member> members, List<NamedValueProvider> namedValueProviders, Creator creator, boolean isEqualsEnabled, boolean primitivesEnabled) {
        this.comment = comment;
        this.name = name;
        this.extend = extend;
        this.mutable = mutable;
        this.isBuilderEnabled = isBuilderEnabled;
        this.arrayNullable = arrayNullable;
        this.collectionNullable = collectionNullable;
        this.creator = creator;
        this.equalsEnabled = isEqualsEnabled;
        this.primitivesEnabled = primitivesEnabled;
        this.annotations.addAll(annotationConfigurations);
        this.members.addAll(members);
        for (Member configuration : members) {
            this.membersByName.put(configuration.name(), configuration);
        }
        for (NamedValueProvider namedValueProvider : namedValueProviders) {
            this.namedValueProviders.put(namedValueProvider.getFieldName(), namedValueProvider);
        }
    }

    public Iterable<Member> members() {
        return this.members;
    }

    public Iterable<Annotation> annotations() {
        return this.annotations;
    }

    public String name() {
        return this.name;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isBuilderEnabled() {
        return this.isBuilderEnabled;
    }

    public Member member(String name) {
        if (name.startsWith("_") && this.membersByName.containsKey(name.substring(1, name.length()))) {
            return this.membersByName.get(name.substring(1, name.length()));
        }
        return this.membersByName.get(name);
    }

    public NamedValueProvider namedValueProvider(String name) {
        return this.namedValueProviders.get(name);
    }

    public String extend() {
        return this.extend;
    }

    public String comment() {
        return this.comment;
    }

    public boolean isArrayNullable() {
        return this.arrayNullable;
    }

    public boolean isCollectionNullable() {
        return this.collectionNullable;
    }

    public Creator creator() {
        return this.creator;
    }

    public boolean isEqualsEnabled() {
        return this.equalsEnabled;
    }

    public boolean isPrimitivesEnabled() {
        return this.primitivesEnabled;
    }
}

