/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.gramma.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.tools.definition.schema.json.gramma.element.IAnnotatable;
import net.anwiba.tools.definition.schema.json.gramma.element.JAnnotation;
import net.anwiba.tools.definition.schema.json.gramma.element.JField;
import net.anwiba.tools.definition.schema.json.gramma.element.JObject;

public class JObjectBuilder
implements IAnnotatable {
    private final Map<String, JField> values = new HashMap<String, JField>();
    private final List<String> names = new ArrayList<String>();
    private final List<JAnnotation> annotations = new ArrayList<JAnnotation>();
    private String comment;

    public void add(JField field) {
        if (field == null) {
            return;
        }
        this.names.add(field.name());
        this.values.put(field.name(), field);
    }

    @Override
    public void add(JAnnotation annotation) {
        if (annotation == null) {
            return;
        }
        this.annotations.add(annotation);
    }

    public JObject build() {
        return new JObject(this.names, this.values, this.annotations, this.comment);
    }

    public void comment(String comment) {
        if (comment == null) {
            return;
        }
        this.comment = this.clean(comment);
    }

    private String clean(String comment) {
        if (comment == null) {
            return null;
        }
        return comment.substring(2, comment.length() - 2).trim().lines().map(line -> line.trim()).map(line -> line.startsWith("*") ? line.substring(1, line.length()).trim() : line).reduce(null, (s, n) -> s == null ? n : s + "\n" + n);
    }
}

