/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.gramma.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.tools.definition.schema.json.gramma.element.IJNode;
import net.anwiba.tools.definition.schema.json.gramma.element.JAnnotation;
import net.anwiba.tools.definition.schema.json.gramma.element.JField;
import net.anwiba.tools.definition.schema.json.gramma.element.JValue;

public class JObject
implements IJNode {
    private final Map<String, JField> values = new HashMap<String, JField>();
    private final List<String> names = new ArrayList<String>();
    private final Map<String, JAnnotation> annotations = new LinkedHashMap<String, JAnnotation>();
    private final String comment;

    JObject(List<String> names, Map<String, JField> values, List<JAnnotation> annotations, String comment) {
        this.comment = comment;
        this.names.addAll(names);
        this.values.putAll(values);
        annotations.forEach(a -> this.annotations.put(a.name(), (JAnnotation)a));
    }

    public String comment() {
        return this.comment;
    }

    public JValue value(String name) {
        return this.values.get(name).value();
    }

    public int numberOfValues() {
        return this.values.size();
    }

    public Iterable<String> names() {
        return this.names;
    }

    public Iterable<JAnnotation> annotations() {
        return this.annotations.values();
    }

    public JField field(String name) {
        return this.values.get(name);
    }

    public boolean hasAnnotation(String name) {
        return this.annotations.containsKey(name);
    }

    public JAnnotation annotation(String name) {
        return this.annotations.get(name);
    }
}

