/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.generator.java.bean;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.tools.definition.schema.json.generator.java.bean.IOutput;
import net.anwiba.tools.definition.schema.json.generator.java.bean.JsonBeanGenerator;
import net.anwiba.tools.definition.schema.json.gramma.parser.JssdParserException;

public class JsonBeanGeneratorExecutor {
    private final String pakkage;
    private final String comment;
    private final File source;
    private final IOutput output;

    public JsonBeanGeneratorExecutor(File source, String pakkage, String comment, IOutput output) {
        this.output = output;
        output.info("source: " + source);
        this.source = source;
        output.info("package: " + pakkage);
        this.pakkage = pakkage;
        output.info("comment: " + comment);
        this.comment = comment;
    }

    public void execute(File target) throws IOException {
        JsonBeanGenerator generator = new JsonBeanGenerator(this.pakkage, this.comment, false);
        String path = this.pakkage.replace('.', File.separatorChar);
        File packageFolder = new File(this.source, path);
        this.output.info("package folder: " + packageFolder);
        File[] files = packageFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().startsWith(".")) {
                    return false;
                }
                String extension = FileUtilities.getExtension((File)pathname);
                if (StringUtilities.isNullOrTrimmedEmpty((String)extension)) {
                    return false;
                }
                return extension.equalsIgnoreCase("jssd");
            }
        });
        if (files == null || files.length == 0) {
            this.output.warn("Found no schema definition files: " + packageFolder);
            return;
        }
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (File file : files) {
            String message;
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.output.info("schema definition: " + file);
                generator.add(inputStream, FileUtilities.getWithoutExtension((File)file).getName());
            }
            catch (FileNotFoundException exception) {
                message = "Couldn't find file: " + file;
                this.output.error(message, exception);
                throwables.add(new IOException(message, exception));
            }
            catch (SecurityException exception) {
                message = "Couldn't read file: " + file + ", because " + exception.getMessage();
                this.output.error(message, exception);
                throwables.add(new IOException(message, exception));
            }
            catch (JssdParserException exception) {
                message = exception.getMessage() + ", in file: " + file;
                this.output.error(message, exception);
                throwables.add(new IOException(message, exception));
            }
            catch (CreationException exception) {
                throwables.add(exception);
                message = "Couldn't create bean description from file: " + file + ", because: " + exception.getMessage();
                this.output.error(message, exception);
                throwables.add(new CreationException(message, (Throwable)exception));
            }
        }
        this.output.info("target: " + target);
        try {
            generator.generate(target);
        }
        catch (IOException | SecurityException exception) {
            this.output.error("Error writing target to: " + target + ", because: " + exception.getMessage(), exception);
            throwables.add(exception);
        }
        IoUtilities.throwIfNotEmpty(throwables);
    }
}

