/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.generator.java.bean;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.tools.definition.schema.json.JSSDReader;
import net.anwiba.tools.definition.schema.json.generator.java.bean.JObjectToBeanConverter;
import net.anwiba.tools.definition.schema.json.gramma.element.JObject;
import net.anwiba.tools.definition.schema.json.gramma.parser.JssdParserException;
import net.anwiba.tools.generator.java.bean.BeanGenerator;

public class JsonBeanGenerator {
    private final String encoding = "UTF-8";
    private final JObjectToBeanConverter objectToBeanConverter;
    private final String comment;
    private final JSSDReader jssdReader = new JSSDReader();
    private final BeanGenerator generator;

    public JsonBeanGenerator(String packageName, String comment, boolean isBuilderBeanPatternEnabled) {
        this.comment = comment;
        this.objectToBeanConverter = new JObjectToBeanConverter(packageName, isBuilderBeanPatternEnabled);
        this.generator = new BeanGenerator(name -> {
            try {
                return JacksonAnnotation.class.getClassLoader().loadClass((String)name);
            }
            catch (ClassNotFoundException exception) {
                throw new CreationException(exception.getMessage(), (Throwable)exception);
            }
        });
    }

    public void add(InputStream inputStream, String name) throws CreationException, IOException, JssdParserException {
        CreationException createException = null;
        for (JObject object : this.jssdReader.read(inputStream, this.encoding)) {
            try {
                this.generator.add(this.objectToBeanConverter.convert(name, object));
            }
            catch (ConversionException exception) {
                if (createException == null) {
                    createException = new CreationException(exception.getMessage(), (Throwable)exception);
                    continue;
                }
                createException.addSuppressed((Throwable)exception);
            }
        }
        if (createException != null) {
            throw createException;
        }
    }

    public void generate(OutputStream ouputStream) throws IOException {
        this.generator.generate(ouputStream);
    }

    public void generate(File targetFolder) throws IOException {
        this.generator.generate(targetFolder, this.comment);
    }
}

