/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.generator.java.bean;

import java.text.MessageFormat;
import net.anwiba.tools.generator.java.bean.JavaConstants;

public class BeanNameConverter {
    private final String packageName;

    public BeanNameConverter(String packageName) {
        this.packageName = packageName;
    }

    public String convert(String name) {
        return this.isSimpleClassName(name) ? MessageFormat.format("{0}.{1}", this.packageName, this.firstLetterToUpperCase(name)) : name;
    }

    private String firstLetterToUpperCase(String name) {
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    private boolean isSimpleClassName(String name) {
        if (name.contains(".")) {
            return false;
        }
        if (JavaConstants.primitives.contains(name)) {
            return false;
        }
        return !this.isInJavaLang(name);
    }

    private boolean isInJavaLang(String name) {
        try {
            Class.forName(MessageFormat.format("java.lang.{0}", name));
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }
}

