/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.generator.java.ant;

import java.io.File;
import java.io.IOException;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.tools.definition.schema.json.generator.java.bean.IOutput;
import net.anwiba.tools.definition.schema.json.generator.java.bean.JsonBeanGeneratorExecutor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JsonBeanGeneratorTask
extends Task {
    private File destination = null;
    private File source = null;
    private String pakkage;
    private String comment;

    public void setPackage(String source) {
        Ensure.ensureArgumentIsNotEmpty((String)source);
        this.pakkage = source;
    }

    public void setComment(String source) {
        Ensure.ensureArgumentIsNotEmpty((String)source);
        this.comment = source;
    }

    public void setSource(String source) throws IOException {
        if (source == null || source.trim().length() == 0) {
            this.source = null;
            return;
        }
        this.source = this.getFile(source);
    }

    public void setDestination(String destination) throws IOException {
        if (destination == null || destination.trim().length() == 0) {
            this.destination = null;
            return;
        }
        this.destination = this.getFile(destination);
    }

    private File getFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file.getCanonicalFile();
        }
        File projectPath = this.getBasePath();
        return new File(projectPath, fileName).getCanonicalFile();
    }

    private File getBasePath() {
        String basedirString = this.getProject().getProperty("basedir");
        File projectPath = new File(basedirString);
        return projectPath;
    }

    public void execute() throws BuildException {
        if (this.destination == null) {
            throw new BuildException("missing target path value");
        }
        if (this.source == null) {
            throw new BuildException("missing source folder value");
        }
        if (this.pakkage == null) {
            throw new BuildException("missing packge name");
        }
        try {
            JsonBeanGeneratorExecutor excecutor = new JsonBeanGeneratorExecutor(this.source, this.pakkage, this.comment, new IOutput(){

                @Override
                public void warn(String message) {
                    JsonBeanGeneratorTask.this.getProject().log(message, 1);
                }

                @Override
                public void info(String message) {
                    JsonBeanGeneratorTask.this.getProject().log(message, 2);
                }

                @Override
                public void error(String message, Throwable throwable) {
                    JsonBeanGeneratorTask.this.getProject().log(message, throwable, 0);
                }
            });
            excecutor.execute(this.destination);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            throw new BuildException(exception);
        }
    }
}

