/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.gramma.element;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.tools.definition.schema.json.gramma.element.JAnnotation;
import net.anwiba.tools.definition.schema.json.gramma.element.JType;
import net.anwiba.tools.definition.schema.json.gramma.element.JValue;

public class JField {
    private final String name;
    private final JValue value;
    private final Map<String, JAnnotation> annotations = new LinkedHashMap<String, JAnnotation>();
    private final JType type;
    private final String fieldComment;
    private final String setterComment;
    private final String getterComment;

    JField(String name, JType type, JValue value, List<JAnnotation> annotations, String fieldComment, String setterComment, String getterComment) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.fieldComment = fieldComment;
        this.setterComment = setterComment;
        this.getterComment = getterComment;
        annotations.forEach(a -> this.annotations.put(a.name(), (JAnnotation)a));
    }

    public String name() {
        return this.name;
    }

    public JValue value() {
        return this.value;
    }

    public Iterable<JAnnotation> annotations() {
        return this.annotations.values();
    }

    public JType type() {
        return this.type;
    }

    public boolean hasAnnotation(String name) {
        return this.annotations.containsKey(name);
    }

    public String fieldComment() {
        return this.fieldComment;
    }

    public String setterComment() {
        return this.setterComment;
    }

    public String getterComment() {
        return this.getterComment;
    }
}

