/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.generator.java.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.tools.definition.schema.json.generator.java.bean.IOutput;
import net.anwiba.tools.definition.schema.json.generator.java.bean.JsonBeanGeneratorExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true)
public class JsonBeanGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}/src/main/jssd", property="jssd.sourceDirectory", required=true)
    private File sourceDirectory = null;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/java-jssd", property="jssd.outputDirectory", required=true)
    private File outputDirectory = null;
    @Parameter(defaultValue="true", property="jssd.addGeneratedSourceToCompileSourceRoot", required=false)
    private boolean addGeneratedSourceToCompileSourceRoot = true;
    @Parameter(defaultValue="false", property="jssd.addJSSDFilesToCompileSourceRoot", required=false)
    private boolean addJSSDFilesToCompileSourceRoot = false;
    @Parameter(required=true)
    private String pakkage;
    @Parameter(required=true)
    private String comment;
    @Component
    private BuildContext buildContext;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setPackage(String pakkage) {
        Ensure.ensureArgumentNotNull((Object)pakkage);
        this.pakkage = pakkage;
    }

    public void setComment(String comment) {
        Ensure.ensureArgumentNotNull((Object)comment);
        this.comment = "//" + comment;
    }

    public void setSourceDirectory(File sourceDirectory) throws IOException {
        this.sourceDirectory = sourceDirectory;
        if (this.isAddJSSDFilesToCompileSourceRootEnabled() && !this.getProject().getCompileSourceRoots().contains(this.sourceDirectory.getPath())) {
            this.getProject().addCompileSourceRoot(this.sourceDirectory.getPath());
        }
    }

    public void setOutputDirectory(File outputDirectory) throws IOException {
        this.outputDirectory = outputDirectory;
    }

    public void setAddGeneratedSourceToCompileSourceRoot(boolean addCompileSourceRoot) {
        this.addGeneratedSourceToCompileSourceRoot = addCompileSourceRoot;
    }

    public boolean isAddGeneratedSourceToCompileSourceRootEnabled() {
        return this.addGeneratedSourceToCompileSourceRoot;
    }

    public void setAddJSSDFilesToCompileSourceRoot(boolean addJSSDFilesToCompileSourceRoot) {
        this.addJSSDFilesToCompileSourceRoot = addJSSDFilesToCompileSourceRoot;
    }

    public boolean isAddJSSDFilesToCompileSourceRootEnabled() {
        return this.addJSSDFilesToCompileSourceRoot;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Executing ...");
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("missing target path value");
        }
        if (this.sourceDirectory == null) {
            throw new MojoExecutionException("missing source folder value");
        }
        if (this.pakkage == null) {
            throw new MojoExecutionException("missing packge name");
        }
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)"Nothing to do");
            return;
        }
        List<File> sources = this.getChildren(this.sourceDirectory);
        if (sources.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to do");
            return;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (this.getProject() != null) {
            if (this.isAddJSSDFilesToCompileSourceRootEnabled() && !this.getProject().getCompileSourceRoots().contains(this.sourceDirectory.getPath())) {
                this.getProject().addCompileSourceRoot(this.sourceDirectory.getPath());
            }
            if (this.isAddGeneratedSourceToCompileSourceRootEnabled() && !this.getProject().getCompileSourceRoots().contains(this.outputDirectory.getPath())) {
                this.getProject().addCompileSourceRoot(this.outputDirectory.getPath());
            }
        }
        if (!this.checkUpToDate(sources)) {
            try {
                JsonBeanGeneratorExecutor excecutor = new JsonBeanGeneratorExecutor(this.sourceDirectory, this.pakkage, this.comment, new IOutput(){

                    @Override
                    public void warn(String message) {
                        JsonBeanGeneratorMojo.this.getLog().warn((CharSequence)message);
                    }

                    @Override
                    public void info(String message) {
                        JsonBeanGeneratorMojo.this.getLog().info((CharSequence)message);
                    }

                    @Override
                    public void error(String message, Throwable throwable) {
                        JsonBeanGeneratorMojo.this.getLog().error((CharSequence)message, throwable);
                    }
                });
                excecutor.excecute(this.outputDirectory);
                this.buildContext.refresh(this.outputDirectory);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Internal exception", e);
            }
        } else {
            this.getLog().info((CharSequence)"Everything is up to date");
        }
    }

    private List<File> getChildren(File directory) {
        ArrayList<File> children = new ArrayList<File>();
        File[] sourceFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return "jssd".equalsIgnoreCase(FileUtilities.getExtension((File)pathname));
            }
        });
        if (sourceFiles == null) {
            return children;
        }
        for (File file : sourceFiles) {
            if (file.isDirectory()) {
                children.addAll(this.getChildren(file));
                continue;
            }
            children.add(file);
        }
        return children;
    }

    private boolean checkUpToDate(List<File> sourceFiles) {
        boolean uptodate = true;
        for (File file : sourceFiles) {
            if (!this.buildContext.hasDelta(file)) continue;
            uptodate = false;
            break;
        }
        return uptodate;
    }
}

