/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.tools.definition.schema.json.gramma.JSSDParser;
import net.anwiba.tools.definition.schema.json.gramma.element.JAnnotation;
import net.anwiba.tools.definition.schema.json.gramma.element.JAnnotationBuilder;
import net.anwiba.tools.definition.schema.json.gramma.element.JDimension;
import net.anwiba.tools.definition.schema.json.gramma.element.JField;
import net.anwiba.tools.definition.schema.json.gramma.element.JFieldBuilder;
import net.anwiba.tools.definition.schema.json.gramma.element.JObject;
import net.anwiba.tools.definition.schema.json.gramma.element.JObjectBuilder;
import net.anwiba.tools.definition.schema.json.gramma.element.JParameter;
import net.anwiba.tools.definition.schema.json.gramma.element.JType;
import net.anwiba.tools.definition.schema.json.gramma.element.JTypeBuilder;
import net.anwiba.tools.definition.schema.json.gramma.element.JValue;
import net.anwiba.tools.definition.schema.json.gramma.parser.JSSDParserFactory;
import net.anwiba.tools.definition.schema.json.gramma.parser.JssdParserException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.Interval;

public class JSSDReader {
    private final JSSDParserFactory factory = new JSSDParserFactory();

    public Iterable<JObject> read(String text) throws IOException, JssdParserException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(text.getBytes("UTF-8")));){
            Iterable<JObject> iterable = this._read(inputStream, "UTF-8");
            return iterable;
        }
    }

    public Iterable<JObject> read(InputStream inputStream, String encoding) throws IOException, JssdParserException {
        return this._read(inputStream, encoding);
    }

    private Iterable<JObject> _read(InputStream byteArrayInputStream, String encoding) throws JssdParserException, IOException {
        try {
            ErrorListener errorListener = new ErrorListener();
            JSSDParser parser = this.factory.create(byteArrayInputStream, encoding, (ANTLRErrorListener)errorListener);
            JSSDParser.JssdContext jssd = parser.jssd();
            if (!errorListener.isEmpty()) {
                String message = StringUtilities.concatenatedString((String)"\n", errorListener.getMessages());
                JssdParserException conversionException = new JssdParserException(message);
                for (RecognitionException recognitionException : errorListener.getExceptions()) {
                    conversionException.addSuppressed(recognitionException);
                }
                throw conversionException;
            }
            ArrayList<JObject> result = new ArrayList<JObject>();
            if (jssd.object() != null) {
                JSSDParser.ObjectContext object = jssd.object();
                result.add(this.convert(object));
                return result;
            }
            JSSDParser.ObjectArrayContext objectarray = jssd.objectArray();
            if (objectarray != null) {
                for (JSSDParser.ObjectContext object : objectarray.object()) {
                    result.add(this.convert(object));
                }
            }
            return result;
        }
        catch (RecognitionException exception) {
            JssdParserException conversionException = new JssdParserException(exception.getMessage());
            conversionException.initCause(exception);
            throw conversionException;
        }
    }

    private JObject convert(JSSDParser.ObjectContext object) {
        JObjectBuilder builder = new JObjectBuilder();
        for (JSSDParser.AnnotationContext annotation : object.annotation()) {
            builder.add(this.convert(annotation));
        }
        builder.comment(this.toString((RuleContext)object.comment()));
        for (JSSDParser.MemberContext member : object.member()) {
            builder.add(this.convert(member));
        }
        return builder.build();
    }

    private JField convert(JSSDParser.MemberContext member) {
        JFieldBuilder builder = new JFieldBuilder();
        for (JSSDParser.AnnotationContext annotation : member.annotation()) {
            builder.add(this.convert(annotation));
        }
        JSSDParser.MemberNameContext name = member.memberName();
        this.addTo(builder, member.comment());
        builder.name(this.convert(name));
        JType type = this.convert(member.type());
        builder.type(type);
        builder.value(this.convert(type, member.value()));
        return builder.build();
    }

    private void addTo(JFieldBuilder builder, JSSDParser.CommentContext memberComment) {
        if (memberComment == null) {
            return;
        }
        builder.fieldComment(this.toString((RuleContext)memberComment));
    }

    private String toString(RuleContext rule) {
        return rule == null ? null : rule.getText();
    }

    private String convert(JSSDParser.MemberNameContext name) {
        String text = name.getText();
        return text.substring(1, text.length() - 1);
    }

    private JValue convert(JType type, JSSDParser.ValueContext value) {
        if (value == null) {
            if (type.isArray()) {
                return null;
            }
            switch (type.name()) {
                case "boolean": {
                    return new JValue(false);
                }
                case "short": 
                case "int": 
                case "long": {
                    return new JValue(0);
                }
                case "float": 
                case "double": {
                    return new JValue(0.0);
                }
            }
            return null;
        }
        if (value.array() != null) {
            ArrayList array = new ArrayList();
            for (JSSDParser.ValueContext valueContext : value.array().value()) {
                JValue arrayValue = this.convert(type, valueContext);
                array.add(arrayValue.value());
            }
            return new JValue(array);
        }
        if (value.NUMBER() != null) {
            String valueString = value.NUMBER().getText();
            if (valueString.indexOf(46) >= 0 || valueString.contains("E") || valueString.contains("e")) {
                return new JValue(Double.parseDouble(valueString));
            }
            return new JValue(Long.parseLong(valueString));
        }
        if (value.STRING() != null) {
            String text = value.getText();
            return new JValue(text.substring(1, text.length() - 1));
        }
        switch (value.getText()) {
            case "false": {
                return new JValue(false);
            }
            case "true": {
                return new JValue(true);
            }
            case "null": {
                return null;
            }
        }
        return new JValue(value.getText());
    }

    private JType convert(JSSDParser.TypeContext type) {
        JTypeBuilder builder = new JTypeBuilder();
        builder.name(this.convert(type.className()));
        JSSDParser.GenericsContext generics = type.generics();
        if (generics != null) {
            for (JSSDParser.ClassNameContext classnameContext : generics.className()) {
                builder.generic(this.convert(classnameContext));
            }
        }
        for (JSSDParser.DimensionContext dimensionContext : type.dimension()) {
            builder.add(JDimension.valueOf(dimensionContext.getText()));
        }
        return builder.build();
    }

    private String convert(JSSDParser.ClassNameContext classname) {
        return classname.getText();
    }

    private JAnnotation convert(JSSDParser.AnnotationContext annotation) {
        JAnnotationBuilder builder = new JAnnotationBuilder();
        String name = this.convert(annotation.annotationName());
        builder.name(name);
        for (JSSDParser.ParameterContext parameter : annotation.parameter()) {
            builder.add(this.convert(parameter));
        }
        return builder.build();
    }

    private String convert(JSSDParser.AnnotationNameContext annotationname) {
        return annotationname.getText();
    }

    private JParameter convert(JSSDParser.ParameterContext parameter) {
        String name = this.convert(parameter.name());
        Object value = this.convert(parameter.parameterValue());
        return new JParameter(name, value);
    }

    private Object convert(JSSDParser.ParameterValueContext value) {
        if (value.NUMBER() != null) {
            String valueString = value.NUMBER().getText();
            if (valueString.indexOf(46) >= 0 || valueString.contains("E") || valueString.contains("e")) {
                return Double.parseDouble(valueString);
            }
            return Long.parseLong(valueString);
        }
        if (value.STRING() != null) {
            String text = value.getText();
            return text.substring(1, text.length() - 1);
        }
        switch (value.getText()) {
            case "false": {
                return false;
            }
            case "true": {
                return true;
            }
            case "null": {
                return null;
            }
        }
        return value.getText();
    }

    private String convert(JSSDParser.NameContext name) {
        return name.getText();
    }

    public final class ErrorListener
    extends BaseErrorListener {
        private final List<RecognitionException> exceptions = new ArrayList<RecognitionException>();
        private final List<String> messages = new ArrayList<String>();

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException exception) {
            Optional.ofNullable(exception).ifPresent(e -> this.exceptions.add((RecognitionException)e));
            this.messages.add("line " + line + ":" + charPositionInLine + ", " + msg);
        }

        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
            this.messages.add("Context sensitivity violation, at " + startIndex + " until " + stopIndex + ", " + recognizer.getTokenStream().getText(Interval.of((int)startIndex, (int)stopIndex)));
        }

        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
            this.messages.add("ambiguity, at " + startIndex + " until " + stopIndex + ", " + recognizer.getTokenStream().getText(Interval.of((int)startIndex, (int)stopIndex)));
        }

        public List<RecognitionException> getExceptions() {
            return this.exceptions;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public boolean isEmpty() {
            return this.messages.isEmpty();
        }
    }
}

