/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.tools.definition.schema.json.gramma.element;

import java.text.MessageFormat;

public class JDimension {
    public static final JDimension INFINITY;
    private static final JDimension DEFAULT;
    private final int value;

    static {
        DEFAULT = INFINITY = new JDimension(Integer.MAX_VALUE);
    }

    private JDimension(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public int hashCode() {
        return 31 + this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JDimension)) {
            return false;
        }
        JDimension other = (JDimension)obj;
        return this.value == other.value;
    }

    public static JDimension valueOf(String value) {
        if (value == null) {
            return DEFAULT;
        }
        StringBuilder builder = new StringBuilder();
        boolean isBracketOpen = false;
        boolean isFirstValueStarted = false;
        boolean isFirstValueFinished = false;
        String text = value.trim();
        int index = 0;
        while (index < text.length()) {
            switch (text.charAt(index)) {
                case '*': {
                    if (index == 0) {
                        return new JDimension(Integer.MAX_VALUE);
                    }
                    throw JDimension.createException(text, index);
                }
                case '[': {
                    if (!isBracketOpen) {
                        isBracketOpen = true;
                        break;
                    }
                    throw JDimension.createException(text, index);
                }
                case ']': {
                    if (!isBracketOpen) {
                        throw JDimension.createException(text, index);
                    }
                    if (!isFirstValueStarted) {
                        return new JDimension(Integer.MAX_VALUE);
                    }
                    if (isFirstValueStarted) {
                        return new JDimension(Integer.valueOf(builder.toString()));
                    }
                    throw JDimension.createException(text, index);
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!isFirstValueStarted) break;
                    isFirstValueFinished = true;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (!isBracketOpen) {
                        throw JDimension.createException(text, index);
                    }
                    if (isFirstValueFinished) {
                        throw JDimension.createException(text, index);
                    }
                    isFirstValueStarted = true;
                    builder.append(text.charAt(index));
                    break;
                }
                default: {
                    throw JDimension.createException(text, index);
                }
            }
            ++index;
        }
        throw new RuntimeException("Unreachable code reached");
    }

    public String toString() {
        return this.value == Integer.MAX_VALUE ? "INFINITY" : String.valueOf(this.value);
    }

    public static JDimension valueOf(int value) {
        return new JDimension(value);
    }

    public static IllegalArgumentException createException(String text, int index) {
        return new IllegalArgumentException(MessageFormat.format("value ''{0}'' at index {1}", text, Integer.toString(index)));
    }
}

